<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Berita;
use App\Models\Produk;
use App\Models\Lowongan;
use App\Models\Demografi;
use App\Models\User;
use Illuminate\Http\Request;

class AdminController extends Controller
{
    // Middleware is handled at route level in web.php

    public function dashboard()
    {
        $stats = [
            'total_berita' => Berita::count(),
            'total_produk' => Produk::count(),
            'total_lowongan' => Lowongan::count(),
            'total_users' => User::count(),
            'berita_published' => Berita::where('status', 'published')->count(),
            'produk_aktif' => Produk::where('status', 'aktif')->count(),
            'lowongan_aktif' => Lowongan::where('status', 'aktif')->count(),
        ];

        $recent_berita = Berita::with('user')
            ->orderBy('created_at', 'desc')
            ->limit(5)
            ->get();

        $recent_produk = Produk::orderBy('created_at', 'desc')
            ->limit(5)
            ->get();

        $recent_lowongan = Lowongan::orderBy('created_at', 'desc')
            ->limit(5)
            ->get();

        return view('admin.dashboard', compact('stats', 'recent_berita', 'recent_produk', 'recent_lowongan'));
    }

    public function profile()
    {
        return view('admin.profile');
    }

    public function updateProfile(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users,email,' . auth()->id(),
            'password' => 'nullable|string|min:8|confirmed',
        ]);

        $user = auth()->user();
        $user->name = $request->name;
        $user->email = $request->email;

        if ($request->filled('password')) {
            $user->password = bcrypt($request->password);
        }

        $user->save();

        return redirect()->route('admin.profile')
            ->with('success', 'Profile berhasil diperbarui.');
    }
}
