<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Anggaran;
use Illuminate\Http\Request;

class AnggaranController extends Controller
{
    public function index()
    {
        $items = Anggaran::orderBy('kategori')->get();
        $total = Anggaran::sum('jumlah');
        return view('admin.anggaran.index', compact('items', 'total'));
    }

    public function create()
    {
        return view('admin.anggaran.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'kategori' => 'required|string|max:255',
            'jumlah' => 'required|numeric|min:0',
            'keterangan' => 'nullable|string',
        ]);
        Anggaran::create($validated);
        return redirect()->route('admin.anggaran.index')->with('success', 'Anggaran berhasil ditambahkan');
    }

    public function edit(Anggaran $anggaran)
    {
        return view('admin.anggaran.edit', compact('anggaran'));
    }

    public function update(Request $request, Anggaran $anggaran)
    {
        $validated = $request->validate([
            'kategori' => 'required|string|max:255',
            'jumlah' => 'required|numeric|min:0',
            'keterangan' => 'nullable|string',
        ]);
        $anggaran->update($validated);
        return redirect()->route('admin.anggaran.index')->with('success', 'Anggaran berhasil diperbarui');
    }

    public function destroy(Anggaran $anggaran)
    {
        $anggaran->delete();
        return redirect()->route('admin.anggaran.index')->with('success', 'Anggaran berhasil dihapus');
    }
}