<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Berita;
use App\Models\Produk;
use App\Models\Lowongan;
use App\Models\User;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    /**
     * Create a new controller instance.
     */
    // Middleware is handled at route level in web.php

    /**
     * Show the admin dashboard.
     */
    public function index()
    {
        $stats = [
            'total_berita' => Berita::count(),
            'total_produk' => Produk::count(),
            'total_lowongan' => Lowongan::count(),
            'total_users' => User::count(),
            'berita_published' => Berita::where('status', 'published')->count(),
            'produk_aktif' => Produk::where('status', 'aktif')->count(),
            'lowongan_aktif' => Lowongan::where('status', 'aktif')->count(),
        ];

        $recent_berita = Berita::with('user')
            ->latest()
            ->take(5)
            ->get();

        $recent_produk = Produk::latest()
            ->take(5)
            ->get();

        return view('admin.dashboard', compact('stats', 'recent_berita', 'recent_produk'));
    }
}
