<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ProfilDesa;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class ProfilDesaController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $profil = ProfilDesa::where('is_active', true)->first();
        return view('admin.profil.index', compact('profil'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.profil.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'nama_desa' => 'required|string|max:255',
            'sejarah' => 'required|string',
            'visi' => 'required|string',
            'misi' => 'required|string',
            'alamat' => 'required|string|max:255',
            'kecamatan' => 'required|string|max:255',
            'kabupaten' => 'required|string|max:255',
            'provinsi' => 'required|string|max:255',
            'kode_pos' => 'nullable|string|max:10',
            'telepon' => 'nullable|string|max:20',
            'email' => 'nullable|email|max:255',
            'website' => 'nullable|url|max:255',
            'luas_wilayah' => 'nullable|numeric|min:0',
            'jumlah_penduduk' => 'nullable|integer|min:0',
            'jumlah_kk' => 'nullable|integer|min:0',
            'jumlah_dusun' => 'nullable|integer|min:0',
            'jumlah_rw' => 'nullable|integer|min:0',
            'jumlah_rt' => 'nullable|integer|min:0',
            'kepala_desa' => 'required|string|max:255',
            'sambutan_kepala_desa' => 'nullable|string',
            'sekdes' => 'nullable|string|max:255',
            'bkd' => 'nullable|string|max:255',
            'bendahara' => 'nullable|string|max:255',
            'foto_kepala_desa' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
            'foto_sekdes' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
            'foto_bkd' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
            'foto_bendahara' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
            'logo_desa' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
            'foto_kantor' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
        ]);

        // Handle file uploads
        $fileFields = ['foto_kepala_desa', 'foto_sekdes', 'foto_bkd', 'foto_bendahara', 'logo_desa', 'foto_kantor'];
        foreach ($fileFields as $field) {
            if ($request->hasFile($field)) {
                $validated[$field] = $request->file($field)->store('profil-desa', 'public');
            }
        }

        // Deactivate existing profile
        ProfilDesa::where('is_active', true)->update(['is_active' => false]);

        // Create new profile
        ProfilDesa::create($validated);

        return redirect()->route('admin.profil.index')->with('success', 'Profil desa berhasil dibuat!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $profil = ProfilDesa::findOrFail($id);
        return view('admin.profil.show', compact('profil'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $profil = ProfilDesa::findOrFail($id);
        return view('admin.profil.edit', compact('profil'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $profil = ProfilDesa::findOrFail($id);
        
        $validated = $request->validate([
            'nama_desa' => 'required|string|max:255',
            'sejarah' => 'required|string',
            'visi' => 'required|string',
            'misi' => 'required|string',
            'alamat' => 'required|string|max:255',
            'kecamatan' => 'required|string|max:255',
            'kabupaten' => 'required|string|max:255',
            'provinsi' => 'required|string|max:255',
            'kode_pos' => 'nullable|string|max:10',
            'telepon' => 'nullable|string|max:20',
            'email' => 'nullable|email|max:255',
            'website' => 'nullable|url|max:255',
            'luas_wilayah' => 'nullable|numeric|min:0',
            'jumlah_penduduk' => 'nullable|integer|min:0',
            'jumlah_kk' => 'nullable|integer|min:0',
            'jumlah_dusun' => 'nullable|integer|min:0',
            'jumlah_rw' => 'nullable|integer|min:0',
            'jumlah_rt' => 'nullable|integer|min:0',
            'kepala_desa' => 'required|string|max:255',
            'sambutan_kepala_desa' => 'nullable|string',
            'sekdes' => 'nullable|string|max:255',
            'bkd' => 'nullable|string|max:255',
            'bendahara' => 'nullable|string|max:255',
            'foto_kepala_desa' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
            'foto_sekdes' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
            'foto_bkd' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
            'foto_bendahara' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
            'logo_desa' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
            'foto_kantor' => 'nullable|image|mimes:jpeg,png,jpg|max:2048',
        ]);

        // Handle file uploads
        $fileFields = ['foto_kepala_desa', 'foto_sekdes', 'foto_bkd', 'foto_bendahara', 'logo_desa', 'foto_kantor'];
        foreach ($fileFields as $field) {
            if ($request->hasFile($field)) {
                // Delete old file if exists
                if ($profil->$field) {
                    Storage::disk('public')->delete($profil->$field);
                }
                $validated[$field] = $request->file($field)->store('profil-desa', 'public');
            }
        }

        $profil->update($validated);

        return redirect()->route('admin.profil.index')->with('success', 'Profil desa berhasil diperbarui!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $profil = ProfilDesa::findOrFail($id);
        
        // Delete associated files
        $fileFields = ['foto_kepala_desa', 'foto_sekdes', 'foto_bkd', 'foto_bendahara', 'logo_desa', 'foto_kantor'];
        foreach ($fileFields as $field) {
            if ($profil->$field) {
                Storage::disk('public')->delete($profil->$field);
            }
        }

        $profil->delete();

        return redirect()->route('admin.profil.index')->with('success', 'Profil desa berhasil dihapus!');
    }
}
