<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProfilDesa extends Model
{
    protected $table = 'profil_desas';
    
    protected $fillable = [
        'nama_desa',
        'sejarah',
        'visi',
        'misi',
        'alamat',
        'kecamatan',
        'kabupaten',
        'provinsi',
        'kode_pos',
        'telepon',
        'email',
        'website',
        'luas_wilayah',
        'jumlah_penduduk',
        'jumlah_kk',
        'jumlah_dusun',
        'jumlah_rw',
        'jumlah_rt',
        'kepala_desa',
        'sambutan_kepala_desa',
        'sekdes',
        'bkd',
        'bendahara',
        'foto_kepala_desa',
        'foto_sekdes',
        'foto_bkd',
        'foto_bendahara',
        'logo_desa',
        'foto_kantor',
        'staf_tambahan',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'luas_wilayah' => 'decimal:2',
        'staf_tambahan' => 'array',
    ];
}
