<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('profil_desas', function (Blueprint $table) {
            $table->id();
            $table->string('nama_desa');
            $table->text('sejarah');
            $table->text('visi');
            $table->text('misi');
            $table->string('alamat');
            $table->string('kecamatan');
            $table->string('kabupaten');
            $table->string('provinsi');
            $table->string('kode_pos')->nullable();
            $table->string('telepon')->nullable();
            $table->string('email')->nullable();
            $table->string('website')->nullable();
            $table->decimal('luas_wilayah', 10, 2)->nullable(); // dalam km2
            $table->integer('jumlah_penduduk')->nullable();
            $table->integer('jumlah_kk')->nullable(); // kepala keluarga
            $table->string('kepala_desa');
            $table->string('sekdes')->nullable(); // sekretaris desa
            $table->string('bkd')->nullable(); // badan koordinasi desa
            $table->string('bendahara')->nullable();
            $table->string('foto_kepala_desa')->nullable();
            $table->string('foto_sekdes')->nullable();
            $table->string('foto_bkd')->nullable();
            $table->string('foto_bendahara')->nullable();
            $table->string('logo_desa')->nullable();
            $table->string('foto_kantor')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('profil_desas');
    }
};
