<?php

namespace Database\Seeders;

use App\Models\Berita;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class BeritaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $admin = User::where('email', 'admin@webdesa.com')->first();
        
        $beritaData = [
            [
                'judul' => 'Pembangunan Jalan Desa Tahap 2 Dimulai',
                'excerpt' => 'Pembangunan jalan desa tahap 2 telah dimulai dengan anggaran dari dana desa tahun 2024.',
                'konten' => 'Pembangunan jalan desa tahap 2 telah resmi dimulai pada hari Senin kemarin. Proyek ini menggunakan anggaran dari dana desa tahun 2024 sebesar 500 juta rupiah. Pembangunan diperkirakan akan selesai dalam waktu 3 bulan ke depan dan akan menghubungkan area perumahan baru dengan jalan utama desa.',
                'status' => 'published',
                'published_at' => now()->subDays(2),
            ],
            [
                'judul' => 'Festival Budaya Desa 2024 Sukses Digelar',
                'excerpt' => 'Festival budaya desa tahun 2024 berhasil digelar dengan meriah dan dihadiri ribuan pengunjung.',
                'konten' => 'Festival budaya desa tahun 2024 telah sukses digelar pada weekend lalu. Acara ini menampilkan berbagai pertunjukan seni tradisional, pameran produk UMKM lokal, dan lomba-lomba menarik. Lebih dari 2000 pengunjung hadir dalam acara ini, termasuk wisatawan dari luar daerah.',
                'status' => 'published',
                'published_at' => now()->subDays(5),
            ],
            [
                'judul' => 'Program Pelatihan UMKM untuk Warga Desa',
                'excerpt' => 'Desa mengadakan program pelatihan UMKM gratis untuk meningkatkan ekonomi warga.',
                'konten' => 'Pemerintah desa bekerja sama dengan Dinas Koperasi dan UMKM mengadakan program pelatihan gratis untuk warga desa. Pelatihan ini meliputi manajemen usaha, pemasaran digital, dan pengelolaan keuangan. Pendaftaran dibuka untuk 50 peserta pertama.',
                'status' => 'published',
                'published_at' => now()->subDays(7),
            ],
            [
                'judul' => 'Renovasi Balai Desa Segera Dimulai',
                'excerpt' => 'Renovasi balai desa akan dimulai bulan depan untuk meningkatkan pelayanan kepada masyarakat.',
                'konten' => 'Renovasi balai desa dijadwalkan akan dimulai bulan depan. Renovasi ini meliputi perbaikan atap, pengecatan ulang, dan penambahan fasilitas komputer untuk pelayanan administrasi yang lebih baik. Selama renovasi, pelayanan akan dipindah ke gedung serbaguna desa.',
                'status' => 'draft',
                'published_at' => null,
            ],
        ];

        foreach ($beritaData as $data) {
            $slug = Str::slug($data['judul']);
            Berita::create([
                'judul' => $data['judul'],
                'slug' => $slug,
                'excerpt' => $data['excerpt'],
                'konten' => $data['konten'],
                'status' => $data['status'],
                'user_id' => $admin->id,
                'published_at' => $data['published_at'],
            ]);
        }
    }
}
