<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Role;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class DefaultAdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create roles if they don't exist
        $adminRole = Role::firstOrCreate([
            'name' => 'admin'
        ], [
            'display_name' => 'Administrator',
            'description' => 'Administrator dengan akses penuh ke sistem'
        ]);

        $superAdminRole = Role::firstOrCreate([
            'name' => 'superadmin'
        ], [
            'display_name' => 'Super Administrator',
            'description' => 'Super Administrator dengan akses tertinggi ke sistem'
        ]);

        // Create default admin user
        User::firstOrCreate([
            'email' => 'admin@desa.com'
        ], [
            'name' => 'Administrator Desa',
            'email' => 'admin@desa.com',
            'password' => Hash::make('123'),
            'role_id' => $adminRole->id,
            'email_verified_at' => now(),
        ]);

        // Create default superadmin user
        User::firstOrCreate([
            'email' => 'superadmin@desa.com'
        ], [
            'name' => 'Super Administrator Desa',
            'email' => 'superadmin@desa.com',
            'password' => Hash::make('123'),
            'role_id' => $superAdminRole->id,
            'email_verified_at' => now(),
        ]);

        $this->command->info('Default admin accounts created successfully!');
        $this->command->info('Admin: admin@desa.com / 123');
        $this->command->info('Super Admin: superadmin@desa.com / 123');
    }
}