<?php

namespace Database\Seeders;

use App\Models\Produk;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class ProdukSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $produkData = [
            [
                'nama' => 'Kopi Arabika Premium',
                'deskripsi' => 'Kopi arabika premium dari kebun lokal desa dengan cita rasa yang khas dan aroma yang harum.',
                'harga' => 85000,
                'stok' => 50,
                'kategori' => 'Minuman',
                'penjual' => 'Pak Budi',
                'kontak_penjual' => '081234567890',
                'status' => 'aktif',
            ],
            [
                'nama' => 'Keripik Tempe Original',
                'deskripsi' => 'Keripik tempe renyah dengan bumbu original yang gurih dan nikmat.',
                'harga' => 15000,
                'stok' => 100,
                'kategori' => 'Makanan',
                'penjual' => 'Ibu Sari',
                'kontak_penjual' => '081234567891',
                'status' => 'aktif',
            ],
            [
                'nama' => 'Sepatu Kulit Handmade',
                'deskripsi' => 'Sepatu kulit berkualitas tinggi buatan pengrajin lokal dengan desain yang elegan.',
                'harga' => 350000,
                'stok' => 20,
                'kategori' => 'Fashion',
                'penjual' => 'Pak Joko',
                'kontak_penjual' => '081234567892',
                'status' => 'aktif',
            ],
            [
                'nama' => 'Madu Hutan Asli',
                'deskripsi' => 'Madu murni dari hutan sekitar desa, tanpa campuran dan pengawet.',
                'harga' => 120000,
                'stok' => 30,
                'kategori' => 'Makanan',
                'penjual' => 'Pak Ahmad',
                'kontak_penjual' => '081234567893',
                'status' => 'aktif',
            ],
            [
                'nama' => 'Tas Anyaman Pandan',
                'deskripsi' => 'Tas anyaman dari daun pandan dengan motif tradisional yang unik.',
                'harga' => 75000,
                'stok' => 25,
                'kategori' => 'Kerajinan',
                'penjual' => 'Ibu Rina',
                'kontak_penjual' => '081234567894',
                'status' => 'aktif',
            ],
        ];

        foreach ($produkData as $data) {
            $slug = Str::slug($data['nama']);
            Produk::create([
                'nama' => $data['nama'],
                'slug' => $slug,
                'deskripsi' => $data['deskripsi'],
                'harga' => $data['harga'],
                'stok' => $data['stok'],
                'kategori' => $data['kategori'],
                'penjual' => $data['penjual'],
                'kontak_penjual' => $data['kontak_penjual'],
                'status' => $data['status'],
            ]);
        }
    }
}
