<?php

namespace Database\Seeders;

use App\Models\Role;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $roles = [
            [
                'name' => 'superadmin',
                'display_name' => 'Super Administrator',
                'description' => 'Super Administrator dengan akses penuh ke semua fitur sistem'
            ],
            [
                'name' => 'admin',
                'display_name' => 'Administrator',
                'description' => 'Administrator dengan akses ke panel admin'
            ],
            [
                'name' => 'user',
                'display_name' => 'User',
                'description' => 'User biasa dengan akses terbatas'
            ]
        ];

        foreach ($roles as $role) {
            Role::create($role);
        }
    }
}
