<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Role;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get role IDs
        $superadminRole = Role::where('name', 'superadmin')->first();
        $adminRole = Role::where('name', 'admin')->first();
        $userRole = Role::where('name', 'user')->first();

        // Create superadmin user
        User::create([
            'name' => 'Super Administrator',
            'email' => 'superadmin@webdesa.com',
            'password' => Hash::make('password123'),
            'role_id' => $superadminRole->id,
            'email_verified_at' => now(),
        ]);

        // Create admin user
        User::create([
            'name' => 'Administrator',
            'email' => 'admin@webdesa.com',
            'password' => Hash::make('password123'),
            'role_id' => $adminRole->id,
            'email_verified_at' => now(),
        ]);

        // Create regular user
        User::create([
            'name' => 'User Demo',
            'email' => 'user@webdesa.com',
            'password' => Hash::make('password123'),
            'role_id' => $userRole->id,
            'email_verified_at' => now(),
        ]);
    }
}
