@extends('admin.layout')

@section('title', 'Edit Anggaran Desa')
@section('page-title', 'Edit Anggaran')

@section('content')
<div class="row">
  <div class="col-12">
    <div class="card">
      <div class="card-header">
        <h5 class="mb-0"><i class="fas fa-edit"></i> Ubah Anggaran</h5>
      </div>
      <div class="card-body">
        <form action="{{ route('admin.anggaran.update', $anggaran) }}" method="POST">
          @csrf
          @method('PUT')
          <div class="row">
            <div class="col-md-6">
              <div class="mb-3">
                <label class="form-label">Keterangan Belanja / Kategori</label>
                <select name="kategori" class="form-select @error('kategori') is-invalid @enderror" required>
                  <option value="">-- Pilih Kategori --</option>
                  @php($options = [
                    'Bidang Penyelenggara Pemerintahan Desa',
                    'Bidang Pelaksanaan Pembangunan Desa',
                    'Bidang Pembinaan Kemasyarakatan Desa',
                    'Bidang Pemberdayaan Masyarakat Desa',
                    'Bidang Penanggulangan Bencana Darurat dan Mendesak Desa',
                  ])
                  @foreach($options as $opt)
                    <option value="{{ $opt }}" {{ $anggaran->kategori === $opt ? 'selected' : '' }}>{{ $opt }}</option>
                  @endforeach
                </select>
                @error('kategori')<div class="invalid-feedback">{{ $message }}</div>@enderror
              </div>
            </div>
            <div class="col-md-6">
              <div class="mb-3">
                <label class="form-label">Jumlah Anggaran (Rp)</label>
                <input type="number" name="jumlah" value="{{ old('jumlah', (int)$anggaran->jumlah) }}" class="form-control @error('jumlah') is-invalid @enderror" min="0" step="1" required>
                @error('jumlah')<div class="invalid-feedback">{{ $message }}</div>@enderror
              </div>
            </div>
            <div class="col-12">
              <div class="mb-3">
                <label class="form-label">Keterangan</label>
                <textarea name="keterangan" class="form-control @error('keterangan') is-invalid @enderror" rows="3">{{ old('keterangan', $anggaran->keterangan) }}</textarea>
                @error('keterangan')<div class="invalid-feedback">{{ $message }}</div>@enderror
              </div>
            </div>
          </div>
          <div class="d-flex justify-content-between">
            <a href="{{ route('admin.anggaran.index') }}" class="btn btn-secondary">Batal</a>
            <button class="btn btn-primary" type="submit">Simpan Perubahan</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
@endsection