@extends('admin.layout')

@section('title', 'Tambah Berita')
@section('page-title', 'Tambah Berita')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-plus"></i> Tambah Berita Baru</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.berita.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-8">
                            <!-- Judul -->
                            <div class="mb-3">
                                <label for="judul" class="form-label">Judul Berita <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('judul') is-invalid @enderror" 
                                       id="judul" name="judul" value="{{ old('judul') }}" required>
                                @error('judul')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Excerpt -->
                            <div class="mb-3">
                                <label for="excerpt" class="form-label">Ringkasan <span class="text-danger">*</span></label>
                                <textarea class="form-control @error('excerpt') is-invalid @enderror" 
                                          id="excerpt" name="excerpt" rows="3" required>{{ old('excerpt') }}</textarea>
                                @error('excerpt')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Ringkasan singkat berita (maksimal 200 karakter)</div>
                            </div>

                            <!-- Konten -->
                            <div class="mb-3">
                                <label for="konten" class="form-label">Konten Berita <span class="text-danger">*</span></label>
                                <textarea class="form-control @error('konten') is-invalid @enderror" 
                                          id="konten" name="konten" rows="15" required>{{ old('konten') }}</textarea>
                                @error('konten')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-4">
                            <!-- Status -->
                            <div class="mb-3">
                                <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                                <select class="form-select @error('status') is-invalid @enderror" 
                                        id="status" name="status" required>
                                    <option value="">Pilih Status</option>
                                    <option value="draft" {{ old('status') == 'draft' ? 'selected' : '' }}>Draft</option>
                                    <option value="published" {{ old('status') == 'published' ? 'selected' : '' }}>Published</option>
                                </select>
                                @error('status')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Kategori -->
                            <div class="mb-3">
                                <label for="kategori" class="form-label">Kategori <span class="text-danger">*</span></label>
                                <select class="form-select @error('kategori') is-invalid @enderror" 
                                        id="kategori" name="kategori" required>
                                    <option value="">Pilih Kategori</option>
                                    <option value="umum" {{ old('kategori') == 'umum' ? 'selected' : '' }}>Umum</option>
                                    <option value="pengumuman" {{ old('kategori') == 'pengumuman' ? 'selected' : '' }}>Pengumuman</option>
                                    <option value="kegiatan" {{ old('kategori') == 'kegiatan' ? 'selected' : '' }}>Kegiatan</option>
                                    <option value="pembangunan" {{ old('kategori') == 'pembangunan' ? 'selected' : '' }}>Pembangunan</option>
                                    <option value="sosial" {{ old('kategori') == 'sosial' ? 'selected' : '' }}>Sosial</option>
                                </select>
                                @error('kategori')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Gambar -->
                            <div class="mb-3">
                                <label for="gambar" class="form-label">Gambar Berita</label>
                                <input type="file" class="form-control @error('gambar') is-invalid @enderror" 
                                       id="gambar" name="gambar" accept="image/*">
                                @error('gambar')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Format: JPG, PNG, GIF. Maksimal 2MB</div>
                            </div>

                            <!-- Preview Gambar -->
                            <div class="mb-3" id="image-preview" style="display: none;">
                                <label class="form-label">Preview Gambar</label>
                                <div class="border rounded p-2">
                                    <img id="preview-img" src="" alt="Preview" class="img-fluid rounded">
                                </div>
                            </div>

                            <!-- Tags -->
                            <div class="mb-3">
                                <label for="tags" class="form-label">Tags</label>
                                <input type="text" class="form-control @error('tags') is-invalid @enderror" 
                                       id="tags" name="tags" value="{{ old('tags') }}" 
                                       placeholder="Pisahkan dengan koma">
                                @error('tags')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Contoh: desa, pembangunan, sosial</div>
                            </div>

                            <!-- Tanggal Publish -->
                            <div class="mb-3">
                                <label for="tanggal_publish" class="form-label">Tanggal Publish</label>
                                <input type="datetime-local" class="form-control @error('tanggal_publish') is-invalid @enderror" 
                                       id="tanggal_publish" name="tanggal_publish" value="{{ old('tanggal_publish') }}">
                                @error('tanggal_publish')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Kosongkan untuk publish sekarang</div>
                            </div>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="row">
                        <div class="col-12">
                            <hr>
                            <div class="d-flex justify-content-between">
                                <a href="{{ route('admin.berita.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left"></i> Kembali
                                </a>
                                <div>
                                    <button type="submit" name="action" value="draft" class="btn btn-outline-primary">
                                        <i class="fas fa-save"></i> Simpan sebagai Draft
                                    </button>
                                    <button type="submit" name="action" value="publish" class="btn btn-primary">
                                        <i class="fas fa-paper-plane"></i> Publish Berita
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Image preview
    const imageInput = document.getElementById('gambar');
    const imagePreview = document.getElementById('image-preview');
    const previewImg = document.getElementById('preview-img');

    imageInput.addEventListener('change', function(e) {
        const file = e.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                previewImg.src = e.target.result;
                imagePreview.style.display = 'block';
            };
            reader.readAsDataURL(file);
        } else {
            imagePreview.style.display = 'none';
        }
    });

    // Auto generate slug from title
    const judulInput = document.getElementById('judul');
    judulInput.addEventListener('input', function() {
        // You can add slug generation logic here if needed
    });

    // Character counter for excerpt
    const excerptTextarea = document.getElementById('excerpt');
    const excerptCounter = document.createElement('div');
    excerptCounter.className = 'form-text text-end';
    excerptTextarea.parentNode.appendChild(excerptCounter);

    function updateExcerptCounter() {
        const length = excerptTextarea.value.length;
        excerptCounter.textContent = `${length}/200 karakter`;
        if (length > 200) {
            excerptCounter.className = 'form-text text-end text-danger';
        } else {
            excerptCounter.className = 'form-text text-end';
        }
    }

    excerptTextarea.addEventListener('input', updateExcerptCounter);
    updateExcerptCounter();
});
</script>

@push('scripts')
<!-- Quill Rich Text Editor -->
<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
<script src="https://cdn.quilljs.com/1.3.6/quill.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Hide the original textarea
    const textarea = document.getElementById('konten');
    textarea.style.display = 'none';
    
    // Create Quill editor container
    const editorContainer = document.createElement('div');
    editorContainer.id = 'quill-editor';
    editorContainer.style.height = '400px';
    textarea.parentNode.insertBefore(editorContainer, textarea);
    
    // Initialize Quill
    const quill = new Quill('#quill-editor', {
        theme: 'snow',
        placeholder: 'Tulis konten berita di sini...',
        modules: {
            toolbar: [
                [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
                ['bold', 'italic', 'underline', 'strike'],
                [{ 'color': [] }, { 'background': [] }],
                [{ 'align': [] }],
                [{ 'list': 'ordered'}, { 'list': 'bullet' }],
                [{ 'indent': '-1'}, { 'indent': '+1' }],
                ['link', 'image'],
                ['clean']
            ]
        }
    });
    
    // Set initial content if editing
    if (textarea.value) {
        quill.root.innerHTML = textarea.value;
    }
    
    // Update textarea when content changes
    quill.on('text-change', function() {
        textarea.value = quill.root.innerHTML;
    });
    
    // Update textarea before form submission
    const form = textarea.closest('form');
    if (form) {
        form.addEventListener('submit', function() {
            textarea.value = quill.root.innerHTML;
        });
    }
});
</script>
@endpush
@endsection