@extends('admin.layout')

@section('title', 'Manajemen Berita')
@section('page-icon', '<i class="fas fa-newspaper text-info me-2"></i>')
@section('page-title', 'Manajemen Berita')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-newspaper"></i> Daftar Berita</h5>
                <a href="{{ route('admin.berita.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Tambah Berita
                </a>
            </div>
            <div class="card-body">
                @if($berita->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th width="5%">#</th>
                                    <th width="15%">Gambar</th>
                                    <th width="30%">Judul</th>
                                    <th width="15%">Kategori</th>
                                    <th width="10%">Status</th>
                                    <th width="10%">Tanggal</th>
                                    <th width="15%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($berita as $index => $item)
                                    <tr>
                                        <td>{{ $berita->firstItem() + $index }}</td>
                                        <td>
                                            @if($item->gambar)
                                                <img src="{{ asset('storage/' . $item->gambar) }}" 
                                                     alt="{{ $item->judul }}" 
                                                     class="img-thumbnail" 
                                                     style="width: 60px; height: 60px; object-fit: cover;">
                                            @else
                                                <div class="bg-light d-flex align-items-center justify-content-center" 
                                                     style="width: 60px; height: 60px;">
                                                    <i class="fas fa-image text-muted"></i>
                                                </div>
                                            @endif
                                        </td>
                                        <td>
                                            <h6 class="mb-1">{{ Str::limit($item->judul, 50) }}</h6>
                                            <small class="text-muted">{{ Str::limit($item->excerpt, 80) }}</small>
                                        </td>
                                        <td>
                                            <span class="badge bg-secondary">{{ $item->kategori }}</span>
                                        </td>
                                        <td>
                                            <span class="badge bg-{{ $item->status == 'published' ? 'success' : 'warning' }}">
                                                {{ ucfirst($item->status) }}
                                            </span>
                                        </td>
                                        <td>
                                            <small>{{ $item->created_at->format('d M Y') }}</small>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('admin.berita.show', $item) }}" 
                                                   class="btn btn-sm btn-info" title="Lihat">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('admin.berita.edit', $item) }}" 
                                                   class="btn btn-sm btn-warning" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('admin.berita.destroy', $item) }}" 
                                                      method="POST" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger" 
                                                            title="Hapus"
                                                            onclick="return confirm('Yakin ingin menghapus berita ini?')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="d-flex justify-content-center">
                        {{ $berita->links() }}
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="fas fa-newspaper fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">Belum ada berita</h5>
                        <p class="text-muted">Mulai dengan menambahkan berita pertama Anda</p>
                        <a href="{{ route('admin.berita.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Tambah Berita
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection