@extends('admin.layout')

@section('title', 'Detail Berita')
@section('page-title', 'Detail Berita')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-eye"></i> Detail Berita</h5>
                <div>
                    <a href="{{ route('admin.berita.edit', $berita) }}" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit"></i> Edit
                    </a>
                    <form action="{{ route('admin.berita.destroy', $berita) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm" 
                                onclick="return confirm('Yakin ingin menghapus berita ini?')">
                            <i class="fas fa-trash"></i> Hapus
                        </button>
                    </form>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-8">
                        <!-- Judul -->
                        <h2 class="mb-3">{{ $berita->judul }}</h2>
                        
                        <!-- Meta Info -->
                        <div class="mb-4">
                            <div class="row">
                                <div class="col-md-6">
                                    <small class="text-muted">
                                        <i class="fas fa-user"></i> {{ $berita->user->name }}<br>
                                        <i class="fas fa-calendar"></i> {{ $berita->created_at->format('d M Y H:i') }}<br>
                                        @if($berita->updated_at != $berita->created_at)
                                            <i class="fas fa-edit"></i> Diupdate: {{ $berita->updated_at->format('d M Y H:i') }}<br>
                                        @endif
                                    </small>
                                </div>
                                <div class="col-md-6 text-md-end">
                                    <span class="badge bg-{{ $berita->status == 'published' ? 'success' : 'warning' }} mb-1">
                                        {{ ucfirst($berita->status) }}
                                    </span><br>
                                    <span class="badge bg-secondary">{{ ucfirst($berita->kategori) }}</span>
                                </div>
                            </div>
                        </div>

                        <!-- Gambar -->
                        @if($berita->gambar)
                            <div class="mb-4">
                                <img src="{{ asset('storage/' . $berita->gambar) }}" 
                                     alt="{{ $berita->judul }}" 
                                     class="img-fluid rounded shadow">
                            </div>
                        @endif

                        <!-- Excerpt -->
                        <div class="mb-4">
                            <h5>Ringkasan</h5>
                            <p class="lead">{{ $berita->excerpt }}</p>
                        </div>

                        <!-- Konten -->
                        <div class="mb-4">
                            <h5>Konten</h5>
                            <div class="content-area">
                                {!! $berita->konten !!}
                            </div>
                        </div>

                        <!-- Tags -->
                        @if($berita->tags)
                            <div class="mb-4">
                                <h6>Tags</h6>
                                @foreach(explode(',', $berita->tags) as $tag)
                                    <span class="badge bg-light text-dark me-1">#{{ trim($tag) }}</span>
                                @endforeach
                            </div>
                        @endif
                    </div>

                    <div class="col-md-4">
                        <!-- Info Panel -->
                        <div class="card bg-light">
                            <div class="card-header">
                                <h6 class="mb-0">Informasi Berita</h6>
                            </div>
                            <div class="card-body">
                                <table class="table table-sm table-borderless">
                                    <tr>
                                        <td><strong>ID:</strong></td>
                                        <td>{{ $berita->id }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Slug:</strong></td>
                                        <td><code>{{ $berita->slug }}</code></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Status:</strong></td>
                                        <td>
                                            <span class="badge bg-{{ $berita->status == 'published' ? 'success' : 'warning' }}">
                                                {{ ucfirst($berita->status) }}
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td><strong>Kategori:</strong></td>
                                        <td>{{ ucfirst($berita->kategori) }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Penulis:</strong></td>
                                        <td>{{ $berita->user->name }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Dibuat:</strong></td>
                                        <td>{{ $berita->created_at->format('d M Y H:i') }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Diupdate:</strong></td>
                                        <td>{{ $berita->updated_at->format('d M Y H:i') }}</td>
                                    </tr>
                                    @if($berita->tanggal_publish)
                                        <tr>
                                            <td><strong>Tanggal Publish:</strong></td>
                                            <td>{{ $berita->tanggal_publish->format('d M Y H:i') }}</td>
                                        </tr>
                                    @endif
                                </table>
                            </div>
                        </div>

                        <!-- Quick Actions -->
                        <div class="card mt-3">
                            <div class="card-header">
                                <h6 class="mb-0">Quick Actions</h6>
                            </div>
                            <div class="card-body">
                                <div class="d-grid gap-2">
                                    @if($berita->status == 'draft')
                                        <form action="{{ route('admin.berita.update', $berita) }}" method="POST">
                                            @csrf
                                            @method('PUT')
                                            <input type="hidden" name="status" value="published">
                                            <button type="submit" class="btn btn-success btn-sm w-100">
                                                <i class="fas fa-paper-plane"></i> Publish Sekarang
                                            </button>
                                        </form>
                                    @else
                                        <form action="{{ route('admin.berita.update', $berita) }}" method="POST">
                                            @csrf
                                            @method('PUT')
                                            <input type="hidden" name="status" value="draft">
                                            <button type="submit" class="btn btn-warning btn-sm w-100">
                                                <i class="fas fa-archive"></i> Jadikan Draft
                                            </button>
                                        </form>
                                    @endif
                                    
                                    <a href="{{ route('admin.berita.edit', $berita) }}" class="btn btn-primary btn-sm">
                                        <i class="fas fa-edit"></i> Edit Berita
                                    </a>
                                    
                                    <button type="button" class="btn btn-info btn-sm" onclick="copyToClipboard('{{ route('berita.show', $berita->slug) }}')">
                                        <i class="fas fa-link"></i> Copy Link
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- SEO Info -->
                        <div class="card mt-3">
                            <div class="card-header">
                                <h6 class="mb-0">SEO Info</h6>
                            </div>
                            <div class="card-body">
                                <small class="text-muted">
                                    <strong>URL:</strong><br>
                                    <code>{{ route('berita.show', $berita->slug) }}</code><br><br>
                                    
                                    <strong>Meta Description:</strong><br>
                                    {{ Str::limit($berita->excerpt, 160) }}<br><br>
                                    
                                    <strong>Karakter Judul:</strong> {{ strlen($berita->judul) }}/60<br>
                                    <strong>Karakter Excerpt:</strong> {{ strlen($berita->excerpt) }}/160
                                </small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="row mt-4">
                    <div class="col-12">
                        <hr>
                        <div class="d-flex justify-content-between">
                            <a href="{{ route('admin.berita.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left"></i> Kembali ke Daftar
                            </a>
                            <div>
                                <a href="{{ route('berita.show', $berita->slug) }}" class="btn btn-info" target="_blank">
                                    <i class="fas fa-external-link-alt"></i> Lihat di Website
                                </a>
                                <a href="{{ route('admin.berita.edit', $berita) }}" class="btn btn-warning">
                                    <i class="fas fa-edit"></i> Edit
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        // Show success message
        const toast = document.createElement('div');
        toast.className = 'toast align-items-center text-white bg-success border-0 position-fixed top-0 end-0 m-3';
        toast.style.zIndex = '9999';
        toast.innerHTML = `
            <div class="d-flex">
                <div class="toast-body">
                    Link berhasil disalin!
                </div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
            </div>
        `;
        document.body.appendChild(toast);
        
        const bsToast = new bootstrap.Toast(toast);
        bsToast.show();
        
        setTimeout(() => {
            document.body.removeChild(toast);
        }, 3000);
    });
}
</script>

<style>
.content-area {
    line-height: 1.8;
    font-size: 1.1rem;
}

.content-area p {
    margin-bottom: 1rem;
}
</style>
@endsection