@extends('admin.layout')

@section('title', 'Tambah Data Demografi')
@section('page-title', 'Tambah Data Demografi')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-plus"></i> Tambah Data Demografi Baru</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.demografi.store') }}" method="POST">
                    @csrf
                    
                    <div class="row">
                        <!-- Kategori -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="kategori" class="form-label">Kategori <span class="text-danger">*</span></label>
                                <select class="form-select @error('kategori') is-invalid @enderror" id="kategori" name="kategori" required>
                                    <option value="">Pilih Kategori</option>
                                    <option value="Jenis Kelamin" {{ old('kategori') == 'Jenis Kelamin' ? 'selected' : '' }}>Jenis Kelamin</option>
                                    <option value="Kelompok Usia" {{ old('kategori') == 'Kelompok Usia' ? 'selected' : '' }}>Kelompok Usia</option>
                                    <option value="Pendidikan" {{ old('kategori') == 'Pendidikan' ? 'selected' : '' }}>Pendidikan</option>
                                    <option value="Pekerjaan" {{ old('kategori') == 'Pekerjaan' ? 'selected' : '' }}>Pekerjaan</option>
                                    <option value="Agama" {{ old('kategori') == 'Agama' ? 'selected' : '' }}>Agama</option>
                                    <option value="Lainnya" {{ old('kategori') == 'Lainnya' ? 'selected' : '' }}>Lainnya</option>
                                </select>
                                @error('kategori')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <!-- Status -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="status" class="form-label">Status</label>
                                <select class="form-select @error('status') is-invalid @enderror" id="status" name="status">
                                    <option value="aktif" {{ old('status') == 'aktif' ? 'selected' : '' }}>Aktif</option>
                                    <option value="nonaktif" {{ old('status') == 'nonaktif' ? 'selected' : '' }}>Non-aktif</option>
                                </select>
                                @error('status')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Label -->
                    <div class="mb-3">
                        <label for="label" class="form-label">Label/Nama Data <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('label') is-invalid @enderror" 
                               id="label" name="label" value="{{ old('label') }}" required
                               placeholder="Contoh: Jumlah Penduduk, Tingkat Pendidikan SMA">
                        @error('label')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="row">
                        <!-- Jumlah -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="jumlah" class="form-label">Jumlah <span class="text-danger">*</span></label>
                                <input type="number" class="form-control @error('jumlah') is-invalid @enderror" 
                                       id="jumlah" name="jumlah" value="{{ old('jumlah') }}" required
                                       min="0" step="1" placeholder="0">
                                @error('jumlah')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <!-- Satuan -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="satuan" class="form-label">Satuan</label>
                                <input type="text" class="form-control @error('satuan') is-invalid @enderror" 
                                       id="satuan" name="satuan" value="{{ old('satuan') }}" 
                                       placeholder="Contoh: orang, %, unit, rumah">
                                <div class="form-text">Kosongkan jika tidak ada satuan</div>
                                @error('satuan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Keterangan -->
                    <div class="mb-3">
                        <label for="keterangan" class="form-label">Keterangan</label>
                        <textarea class="form-control @error('keterangan') is-invalid @enderror" 
                                  id="keterangan" name="keterangan" rows="4" 
                                  placeholder="Keterangan tambahan tentang data ini...">{{ old('keterangan') }}</textarea>
                        @error('keterangan')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Sumber Data -->
                    <div class="mb-3">
                        <label for="sumber" class="form-label">Sumber Data</label>
                        <input type="text" class="form-control @error('sumber') is-invalid @enderror" 
                               id="sumber" name="sumber" value="{{ old('sumber') }}" 
                               placeholder="Contoh: BPS, Kantor Desa, Survey Internal">
                        @error('sumber')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Tahun Data -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="tahun" class="form-label">Tahun Data</label>
                                <input type="number" class="form-control @error('tahun') is-invalid @enderror" 
                                       id="tahun" name="tahun" value="{{ old('tahun', date('Y')) }}" 
                                       min="2000" max="{{ date('Y') + 1 }}">
                                @error('tahun')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Buttons -->
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.demografi.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                        <div>
                            <button type="reset" class="btn btn-outline-secondary me-2">
                                <i class="fas fa-undo"></i> Reset
                            </button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Simpan Data
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto-suggest satuan based on kategori
    const kategoriSelect = document.getElementById('kategori');
    const satuanInput = document.getElementById('satuan');
    
    const satuanSuggestions = {
        'penduduk': 'orang',
        'ekonomi': 'rupiah',
        'pendidikan': 'orang',
        'kesehatan': 'orang',
        'infrastruktur': 'unit'
    };
    
    kategoriSelect.addEventListener('change', function() {
        if (satuanInput.value === '' && satuanSuggestions[this.value]) {
            satuanInput.value = satuanSuggestions[this.value];
        }
    });
});
</script>
@endsection