@extends('admin.layout')

@section('title', 'Detail Data Demografi')
@section('page-title', 'Detail Data Demografi')

@section('content')
<div class="row">
    <!-- Main Content -->
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="fas fa-chart-bar"></i> {{ $demografi->label }}</h5>
                    <span class="badge bg-info fs-6">
                        {{ $demografi->tahun ?? 'N/A' }}
                    </span>
                </div>
            </div>
            <div class="card-body">
                <!-- Nilai Utama -->
                <div class="text-center mb-4">
                    <div class="display-4 text-primary fw-bold">
                        {{ number_format($demografi->jumlah, 0, ',', '.') }}
                    </div>
                    <p class="text-muted mb-0">{{ $demografi->label }}</p>
                </div>

                <!-- Kategori -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-tag text-info me-2"></i>
                            <span class="fw-bold me-2">Kategori:</span>
                            <span class="badge bg-info">{{ ucfirst($demografi->kategori) }}</span>
                        </div>
                    </div>
                </div>

                <!-- Keterangan -->
                @if($demografi->keterangan)
                <div class="mb-4">
                    <h6><i class="fas fa-info-circle text-info"></i> Keterangan</h6>
                    <div class="bg-light p-3 rounded">
                        {{ $demografi->keterangan }}
                    </div>
                </div>
                @endif

                <!-- Tahun Data -->
                @if($demografi->tahun)
                <div class="mb-4">
                    <h6><i class="fas fa-calendar text-warning"></i> Tahun Data</h6>
                    <p class="mb-0">{{ $demografi->tahun }}</p>
                </div>
                @endif

                <!-- Quick Actions -->
                <div class="d-flex gap-2 flex-wrap">
                    <button class="btn btn-outline-info btn-sm" onclick="copyData()">
                        <i class="fas fa-copy"></i> Salin Data
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Sidebar -->
    <div class="col-lg-4">
        <!-- Info Panel -->
        <div class="card mb-4">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-info"></i> Info Panel</h6>
            </div>
            <div class="card-body">
                <table class="table table-sm table-borderless">
                    <tr>
                        <td><strong>ID:</strong></td>
                        <td>{{ $demografi->id }}</td>
                    </tr>
                    <tr>
                        <td><strong>Kategori:</strong></td>
                        <td><span class="badge bg-info">{{ ucfirst($demografi->kategori) }}</span></td>
                    </tr>
                    <tr>
                        <td><strong>Jumlah:</strong></td>
                        <td>
                            <strong>{{ number_format($demografi->jumlah, 0, ',', '.') }}</strong>
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Keterangan:</strong></td>
                        <td>{{ $demografi->keterangan ?? 'Tidak ada keterangan' }}</td>
                    </tr>
                    @if($demografi->tahun)
                    <tr>
                        <td><strong>Tahun:</strong></td>
                        <td>{{ $demografi->tahun }}</td>
                    </tr>
                    @endif
                    <tr>
                        <td><strong>Dibuat:</strong></td>
                        <td>{{ $demografi->created_at->format('d/m/Y H:i') }}</td>
                    </tr>
                    <tr>
                        <td><strong>Diupdate:</strong></td>
                        <td>{{ $demografi->updated_at->format('d/m/Y H:i') }}</td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-cogs"></i> Aksi</h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('admin.demografi.edit', $demografi->id) }}" class="btn btn-warning">
                        <i class="fas fa-edit"></i> Edit Data
                    </a>
                    
                    <button class="btn btn-danger" onclick="confirmDelete()">
                        <i class="fas fa-trash"></i> Hapus Data
                    </button>
                    
                    <hr>
                    
                    <a href="{{ route('admin.demografi.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Kembali ke Daftar
                    </a>
                </div>
            </div>
        </div>

        <!-- Data Comparison -->
        <div class="card mt-4">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-chart-line"></i> Perbandingan Data</h6>
            </div>
            <div class="card-body">
                <p class="text-muted small">Fitur perbandingan dengan data serupa akan tersedia segera.</p>
                
                <!-- Placeholder for future comparison feature -->
                <div class="bg-light p-3 rounded text-center">
                    <i class="fas fa-chart-bar fa-2x text-muted mb-2"></i>
                    <p class="text-muted small mb-0">Grafik perbandingan data kategori {{ $demografi->kategori }}</p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Navigation -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        {{-- Previous data navigation will be implemented when needed --}}
                        <button class="btn btn-outline-secondary btn-sm" disabled>
                            <i class="fas fa-chevron-left"></i> Data Sebelumnya
                        </button>
                    </div>
                    
                    <div>
                        <a href="{{ route('admin.demografi.index') }}" class="btn btn-primary">
                            <i class="fas fa-list"></i> Semua Data Demografi
                        </a>
                    </div>
                    
                    <div>
                        {{-- Next data navigation will be implemented when needed --}}
                        <button class="btn btn-outline-secondary btn-sm" disabled>
                            Data Selanjutnya <i class="fas fa-chevron-right"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Hidden form for update -->
<form id="updateForm" action="{{ route('admin.demografi.update', $demografi->id) }}" method="POST" style="display: none;">
    @csrf
    @method('PUT')
    <input type="hidden" name="kategori" value="{{ $demografi->kategori }}">
    <input type="hidden" name="label" value="{{ $demografi->label }}">
    <input type="hidden" name="jumlah" value="{{ $demografi->jumlah }}">
    <input type="hidden" name="keterangan" value="{{ $demografi->keterangan }}">
    <input type="hidden" name="tahun" value="{{ $demografi->tahun }}">
</form>

<!-- Hidden form for delete -->
<form id="deleteForm" action="{{ route('admin.demografi.destroy', $demografi->id) }}" method="POST" style="display: none;">
    @csrf
    @method('DELETE')
</form>

<script>
function confirmDelete() {
    if (confirm('Apakah Anda yakin ingin menghapus data demografi ini?\n\nData: {{ $demografi->label }}\nJumlah: {{ number_format($demografi->jumlah, 0, ",", ".") }}\n\nTindakan ini tidak dapat dibatalkan!')) {
        document.getElementById('deleteForm').submit();
    }
}

function copyData() {
    const dataText = `Data Demografi: {{ $demografi->label }}
Kategori: {{ ucfirst($demografi->kategori) }}
Jumlah: {{ number_format($demografi->jumlah, 0, ",", ".") }}
@if($demografi->tahun)Tahun: {{ $demografi->tahun }}@endif
@if($demografi->keterangan)Keterangan: {{ $demografi->keterangan }}@endif`;

    navigator.clipboard.writeText(dataText).then(function() {
        alert('Data berhasil disalin ke clipboard!');
    }, function(err) {
        console.error('Gagal menyalin data: ', err);
        alert('Gagal menyalin data ke clipboard.');
    });
}

// Auto-refresh data if needed (can be implemented later)
document.addEventListener('DOMContentLoaded', function() {
    // Future: Add real-time data updates if needed
});
</script>
@endsection