<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Admin Panel') - WebDesa</title>

    <!-- ========== Favicon ========== -->
    @if(!empty($profilDesa?->logo_desa))
        <link rel="icon" type="image/png" href="{{ asset('storage/' . $profilDesa->logo_desa) }}">
    @else
        <link rel="icon" type="image/svg+xml"
              href="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24' fill='%232c3e50'%3E%3Cpath d='M12 2L2 7v10c0 5.55 3.84 9.739 9 11 5.16-1.261 9-5.45 9-11V7l-10-5z'/%3E%3Cpath d='M12 7L6.5 10v4c0 2.775 1.92 4.87 4.5 5.5 2.58-.63 4.5-2.725 4.5-5.5v-4L12 7z' fill='%23fff'/%3E%3C/svg%3E">
    @endif

    <!-- ========== Stylesheets ========== -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

    <!-- ========== Custom Styles ========== -->
    <style>
        :root {
            --sidebar-width: 250px;
            --primary-color: #2c3e50;
            --secondary-color: #34495e;
            --accent-color: #3498db;
            --success-color: #27ae60;
            --warning-color: #f39c12;
            --danger-color: #e74c3c;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f9fa;
        }

        /* Sidebar */
        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            width: var(--sidebar-width);
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            color: #fff;
            overflow-y: auto;
            transition: all 0.3s ease;
            z-index: 1000;
        }

        .sidebar-header {
            padding: 1.5rem;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }

        .sidebar-header h5 {
            margin: 0;
            font-weight: 600;
        }

        .sidebar-menu .nav-link {
            color: rgba(255,255,255,0.85);
            padding: 0.75rem 1.5rem;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
        }

        .sidebar-menu .nav-link:hover,
        .sidebar-menu .nav-link.active {
            color: #fff;
            background-color: rgba(255,255,255,0.1);
            border-left: 3px solid var(--accent-color);
        }

        .sidebar-menu .nav-link i {
            width: 20px;
            margin-right: 10px;
        }

        /* Main Area */
        .main-content {
            margin-left: var(--sidebar-width);
            min-height: 100vh;
            transition: all 0.3s ease;
        }

        .top-navbar {
            background: #fff;
            box-shadow: 0 2px 4px rgba(0,0,0,0.08);
            padding: 1rem 2rem;
            margin-bottom: 1.5rem;
        }

        .content-wrapper {
            padding: 0 2rem 2rem;
        }

        /* Cards */
        .card {
            border: none;
            box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            border-radius: 10px;
        }

        .card-header {
            background: linear-gradient(135deg, var(--accent-color), #5dade2);
            color: #fff;
            border-radius: 10px 10px 0 0 !important;
            border: none;
        }

        /* Buttons */
        .btn-primary {
            background: linear-gradient(135deg, var(--accent-color), #5dade2);
            border: none;
        }

        .btn-success {
            background: linear-gradient(135deg, var(--success-color), #58d68d);
            border: none;
        }

        .btn-warning {
            background: linear-gradient(135deg, var(--warning-color), #f7dc6f);
            border: none;
        }

        .btn-danger {
            background: linear-gradient(135deg, var(--danger-color), #ec7063);
            border: none;
        }

        /* Table */
        .table thead th {
            background: var(--primary-color);
            color: #fff;
            border: none;
        }

        /* Responsive Sidebar */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .sidebar.show {
                transform: translateX(0);
            }

            .main-content {
                margin-left: 0;
            }
        }
    </style>

    @stack('styles')
</head>

<body>
    <!-- ========== Sidebar ========== -->
    <nav class="sidebar" id="sidebar">
        <div class="sidebar-header d-flex align-items-center">
            @if(!empty($profilDesa?->logo_desa))
                <img src="{{ asset('storage/' . $profilDesa->logo_desa) }}"
                     alt="Logo Desa"
                     class="me-3"
                     style="width: 40px; height: 40px; object-fit: contain;">
            @else
                <i class="fas fa-shield-alt text-warning me-3" style="font-size: 2rem;"></i>
            @endif

            <div>
                <h5 class="mb-0">{{ $profilDesa->nama_desa ?? 'WebDesa Admin' }}</h5>
                <small class="text-light opacity-75">Panel Administrasi</small>
            </div>
        </div>

        <div class="sidebar-menu">
            <ul class="nav flex-column">
                <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}" href="{{ route('admin.dashboard') }}">
                        <i class="fas fa-home"></i> Dashboard
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('admin.berita.*') ? 'active' : '' }}" href="{{ route('admin.berita.index') }}">
                        <i class="fas fa-newspaper"></i> Berita
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('admin.produk.*') ? 'active' : '' }}" href="{{ route('admin.produk.index') }}">
                        <i class="fas fa-box"></i> Produk
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('admin.lowongan.*') ? 'active' : '' }}" href="{{ route('admin.lowongan.index') }}">
                        <i class="fas fa-briefcase"></i> Lowongan
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('admin.demografi.*') ? 'active' : '' }}" href="{{ route('admin.demografi.index') }}">
                        <i class="fas fa-chart-pie"></i> Demografi
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('admin.profil.*') ? 'active' : '' }}" href="{{ route('admin.profil.index') }}">
                        <i class="fas fa-building"></i> Profil Desa
                    </a>
                </li>
                <li class="nav-item ms-3">
                    <a class="nav-link {{ request()->routeIs('admin.anggaran.*') ? 'active' : '' }}" href="{{ route('admin.anggaran.index') }}">
                        <i class="fas fa-money-bill-wave"></i> Transparansi Anggaran
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('admin.staf.*') ? 'active' : '' }}" href="{{ route('admin.staf.index') }}">
                        <i class="fas fa-users"></i> Staf Desa
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('admin.profile') ? 'active' : '' }}" href="{{ route('admin.profile') }}">
                        <i class="fas fa-user"></i> Profil
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('home') }}" target="_blank">
                        <i class="fas fa-external-link-alt"></i> Lihat Website
                    </a>
                </li>
                <li class="nav-item">
                    <form action="{{ route('logout') }}" method="POST" class="d-inline">
                        @csrf
                        <button type="submit" class="nav-link border-0 bg-transparent w-100 text-start">
                            <i class="fas fa-sign-out-alt"></i> Logout
                        </button>
                    </form>
                </li>
            </ul>
        </div>
    </nav>

    <!-- ========== Main Content ========== -->
    <div class="main-content">
        <!-- Top Navbar -->
        <div class="top-navbar d-flex justify-content-between align-items-center">
            <div>
                <button class="btn btn-outline-primary d-md-none" id="sidebarToggle">
                    <i class="fas fa-bars"></i>
                </button>
                <h5 class="mb-0 d-none d-md-inline">
                    @yield('page-title', 'Dashboard')
                </h5>
            </div>

            <div class="d-flex align-items-center">
                <span class="me-3">Selamat datang, {{ auth()->user()->name }}</span>
                <div class="dropdown">
                    <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                        <i class="fas fa-user"></i>
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="{{ route('admin.profile') }}">Profil</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <form action="{{ route('logout') }}" method="POST">
                                @csrf
                                <button type="submit" class="dropdown-item">Logout</button>
                            </form>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Content Section -->
        <div class="content-wrapper">
            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="fas fa-check-circle"></i> {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @yield('content')
        </div>
    </div>

    <!-- ========== Scripts ========== -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        // Sidebar toggle for mobile
        document.getElementById('sidebarToggle')?.addEventListener('click', () => {
            document.getElementById('sidebar').classList.toggle('show');
        });

        // Auto-hide alerts
        setTimeout(() => {
            document.querySelectorAll('.alert').forEach(alert => {
                if (alert.classList.contains('show')) {
                    alert.classList.remove('show');
                    setTimeout(() => alert.remove(), 150);
                }
            });
        }, 5000);
    </script>

    @stack('scripts')
</body>
</html>
