@extends('admin.layout')

@section('title', 'Tambah Lowongan')
@section('page-title', 'Tambah Lowongan')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-plus"></i> Tambah Lowongan Kerja Baru</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.lowongan.store') }}" method="POST">
                    @csrf
                    
                    <div class="row">
                        <!-- Posisi -->
                        <div class="col-md-8">
                            <div class="mb-3">
                                <label for="posisi" class="form-label">Posisi/Jabatan <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('posisi') is-invalid @enderror" 
                                       id="posisi" name="posisi" value="{{ old('posisi') }}" required
                                       placeholder="Contoh: Staff Admin, Marketing Executive">
                                @error('posisi')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <!-- Status -->
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="status" class="form-label">Status</label>
                                <select class="form-select @error('status') is-invalid @enderror" id="status" name="status">
                                    <option value="aktif" {{ old('status') == 'aktif' ? 'selected' : '' }}>Aktif</option>
                                    <option value="nonaktif" {{ old('status') == 'nonaktif' ? 'selected' : '' }}>Non-aktif</option>
                                </select>
                                @error('status')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <!-- Perusahaan -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="perusahaan" class="form-label">Nama Perusahaan <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('perusahaan') is-invalid @enderror" 
                                       id="perusahaan" name="perusahaan" value="{{ old('perusahaan') }}" required
                                       placeholder="Nama perusahaan atau instansi">
                                @error('perusahaan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <!-- Lokasi -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="lokasi" class="form-label">Lokasi <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('lokasi') is-invalid @enderror" 
                                       id="lokasi" name="lokasi" value="{{ old('lokasi') }}" required
                                       placeholder="Contoh: Jakarta, Bandung, Remote">
                                @error('lokasi')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Deskripsi -->
                    <div class="mb-3">
                        <label for="deskripsi" class="form-label">Deskripsi Singkat</label>
                        <textarea class="form-control @error('deskripsi') is-invalid @enderror" 
                                  id="deskripsi" name="deskripsi" rows="3" 
                                  placeholder="Deskripsi singkat tentang pekerjaan...">{{ old('deskripsi') }}</textarea>
                        <div class="form-text">
                            <span id="deskripsi-count">0</span>/200 karakter
                        </div>
                        @error('deskripsi')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Persyaratan -->
                    <div class="mb-3">
                        <label for="persyaratan" class="form-label">Persyaratan</label>
                        <textarea class="form-control @error('persyaratan') is-invalid @enderror" 
                                  id="persyaratan" name="persyaratan" rows="6" 
                                  placeholder="Daftar persyaratan untuk posisi ini...">{{ old('persyaratan') }}</textarea>
                        @error('persyaratan')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="row">
                        <!-- Gaji Min -->
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="gaji_min" class="form-label">Gaji Minimum</label>
                                <div class="input-group">
                                    <span class="input-group-text">Rp</span>
                                    <input type="number" class="form-control @error('gaji_min') is-invalid @enderror" 
                                           id="gaji_min" name="gaji_min" value="{{ old('gaji_min') }}" 
                                           min="0" step="100000" placeholder="0">
                                </div>
                                @error('gaji_min')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <!-- Gaji Max -->
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="gaji_max" class="form-label">Gaji Maksimum</label>
                                <div class="input-group">
                                    <span class="input-group-text">Rp</span>
                                    <input type="number" class="form-control @error('gaji_max') is-invalid @enderror" 
                                           id="gaji_max" name="gaji_max" value="{{ old('gaji_max') }}" 
                                           min="0" step="100000" placeholder="0">
                                </div>
                                @error('gaji_max')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <!-- Tipe Kerja -->
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="tipe_kerja" class="form-label">Tipe Kerja</label>
                                <select class="form-select @error('tipe_kerja') is-invalid @enderror" id="tipe_kerja" name="tipe_kerja">
                                    <option value="">Pilih Tipe</option>
                                    <option value="full-time" {{ old('tipe_kerja') == 'full-time' ? 'selected' : '' }}>Full Time</option>
                                    <option value="part-time" {{ old('tipe_kerja') == 'part-time' ? 'selected' : '' }}>Part Time</option>
                                    <option value="contract" {{ old('tipe_kerja') == 'contract' ? 'selected' : '' }}>Kontrak</option>
                                    <option value="freelance" {{ old('tipe_kerja') == 'freelance' ? 'selected' : '' }}>Freelance</option>
                                    <option value="internship" {{ old('tipe_kerja') == 'internship' ? 'selected' : '' }}>Magang</option>
                                </select>
                                @error('tipe_kerja')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Deadline -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="deadline" class="form-label">Deadline Lamaran</label>
                                <input type="date" class="form-control @error('deadline') is-invalid @enderror" 
                                       id="deadline" name="deadline" value="{{ old('deadline') }}" 
                                       min="{{ date('Y-m-d') }}">
                                <div class="form-text">Kosongkan jika tidak ada deadline</div>
                                @error('deadline')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Kontak -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="kontak_nama" class="form-label">Nama Kontak</label>
                                <input type="text" class="form-control @error('kontak_nama') is-invalid @enderror" 
                                       id="kontak_nama" name="kontak_nama" value="{{ old('kontak_nama') }}" 
                                       placeholder="Nama HR atau kontak person">
                                @error('kontak_nama')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="kontak_email" class="form-label">Email Kontak</label>
                                <input type="email" class="form-control @error('kontak_email') is-invalid @enderror" 
                                       id="kontak_email" name="kontak_email" value="{{ old('kontak_email') }}" 
                                       placeholder="email@perusahaan.com">
                                @error('kontak_email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="kontak_hp" class="form-label">No. HP/WhatsApp</label>
                                <input type="text" class="form-control @error('kontak_hp') is-invalid @enderror" 
                                       id="kontak_hp" name="kontak_hp" value="{{ old('kontak_hp') }}" 
                                       placeholder="08xxxxxxxxxx">
                                @error('kontak_hp')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Buttons -->
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.lowongan.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                        <div>
                            <button type="reset" class="btn btn-outline-secondary me-2">
                                <i class="fas fa-undo"></i> Reset
                            </button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Simpan Lowongan
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Character count for deskripsi
    const deskripsiTextarea = document.getElementById('deskripsi');
    const deskripsiCount = document.getElementById('deskripsi-count');
    
    function updateDeskripsiCount() {
        const count = deskripsiTextarea.value.length;
        deskripsiCount.textContent = count;
        
        if (count > 200) {
            deskripsiCount.classList.add('text-danger');
        } else {
            deskripsiCount.classList.remove('text-danger');
        }
    }
    
    deskripsiTextarea.addEventListener('input', updateDeskripsiCount);
    updateDeskripsiCount(); // Initial count
    
    // Validate gaji range
    const gajiMin = document.getElementById('gaji_min');
    const gajiMax = document.getElementById('gaji_max');
    
    function validateGajiRange() {
        const min = parseInt(gajiMin.value) || 0;
        const max = parseInt(gajiMax.value) || 0;
        
        if (min > 0 && max > 0 && min > max) {
            gajiMax.setCustomValidity('Gaji maksimum harus lebih besar dari gaji minimum');
        } else {
            gajiMax.setCustomValidity('');
        }
    }
    
    gajiMin.addEventListener('input', validateGajiRange);
    gajiMax.addEventListener('input', validateGajiRange);
});
</script>
@endsection