@extends('admin.layout')

@section('title', 'Detail Lowongan Kerja')
@section('page-icon', '<i class="fas fa-briefcase text-warning me-2"></i>')
@section('page-title', 'Detail Lowongan Kerja')

@section('content')
<div class="row">
    <!-- Main Content -->
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="fas fa-briefcase"></i> {{ $lowongan->posisi }}</h5>
                    <span class="badge {{ $lowongan->status == 'aktif' ? 'bg-success' : ($lowongan->status == 'expired' ? 'bg-danger' : 'bg-secondary') }} fs-6">
                        {{ ucfirst($lowongan->status) }}
                    </span>
                </div>
            </div>
            <div class="card-body">
                <!-- Company Info -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="d-flex align-items-center mb-2">
                            <i class="fas fa-building text-primary me-2"></i>
                            <span class="fw-bold">{{ $lowongan->perusahaan }}</span>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="d-flex align-items-center mb-2">
                            <i class="fas fa-map-marker-alt text-danger me-2"></i>
                            <span>{{ $lowongan->lokasi }}</span>
                        </div>
                    </div>
                </div>

                <!-- Job Type & Salary -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="d-flex align-items-center mb-2">
                            <i class="fas fa-clock text-info me-2"></i>
                            <span class="badge bg-info">{{ ucfirst(str_replace('_', ' ', $lowongan->tipe_pekerjaan)) }}</span>
                        </div>
                    </div>
                    <div class="col-md-6">
                        @if($lowongan->gaji_min || $lowongan->gaji_max)
                        <div class="d-flex align-items-center mb-2">
                            <i class="fas fa-money-bill-wave text-success me-2"></i>
                            <span class="fw-bold text-success">
                                @if($lowongan->gaji_min && $lowongan->gaji_max)
                                    Rp {{ number_format($lowongan->gaji_min) }} - Rp {{ number_format($lowongan->gaji_max) }}
                                @elseif($lowongan->gaji_min)
                                    Minimal Rp {{ number_format($lowongan->gaji_min) }}
                                @else
                                    Maksimal Rp {{ number_format($lowongan->gaji_max) }}
                                @endif
                            </span>
                        </div>
                        @else
                        <div class="d-flex align-items-center mb-2">
                            <i class="fas fa-money-bill-wave text-muted me-2"></i>
                            <span class="text-muted">Gaji akan dibicarakan</span>
                        </div>
                        @endif
                    </div>
                </div>

                <!-- Deadline -->
                <div class="mb-4">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-calendar-alt text-warning me-2"></i>
                        <span class="fw-bold me-2">Deadline:</span>
                        @if($lowongan->deadline)
                            <span class="me-2">{{ $lowongan->deadline->format('d F Y') }}</span>
                            @if($lowongan->deadline->isPast())
                                <span class="badge bg-danger">Expired</span>
                            @elseif($lowongan->deadline->diffInDays() <= 7)
                                <span class="badge bg-warning">{{ $lowongan->deadline->diffInDays() }} hari lagi</span>
                            @else
                                <span class="badge bg-success">{{ $lowongan->deadline->diffInDays() }} hari lagi</span>
                            @endif
                        @else
                            <span class="text-muted">Tidak ditentukan</span>
                        @endif
                    </div>
                </div>

                <!-- Deskripsi Singkat -->
                <div class="mb-4">
                    <h6><i class="fas fa-info-circle text-info"></i> Deskripsi Singkat</h6>
                    <div class="bg-light p-3 rounded">
                        {{ $lowongan->deskripsi_singkat }}
                    </div>
                </div>

                <!-- Persyaratan -->
                <div class="mb-4">
                    <h6><i class="fas fa-list-check text-success"></i> Persyaratan</h6>
                    <div class="bg-light p-3 rounded">
                        <pre class="mb-0" style="white-space: pre-wrap; font-family: inherit;">{{ $lowongan->persyaratan }}</pre>
                    </div>
                </div>

                <!-- Kontak -->
                @if($lowongan->kontak_nama || $lowongan->kontak_email || $lowongan->kontak_telepon)
                <div class="mb-4">
                    <h6><i class="fas fa-address-book text-primary"></i> Informasi Kontak</h6>
                    <div class="bg-light p-3 rounded">
                        @if($lowongan->kontak_nama)
                        <div class="mb-2">
                            <i class="fas fa-user me-2"></i>
                            <strong>{{ $lowongan->kontak_nama }}</strong>
                        </div>
                        @endif
                        @if($lowongan->kontak_email)
                        <div class="mb-2">
                            <i class="fas fa-envelope me-2"></i>
                            <a href="mailto:{{ $lowongan->kontak_email }}">{{ $lowongan->kontak_email }}</a>
                        </div>
                        @endif
                        @if($lowongan->kontak_telepon)
                        <div class="mb-2">
                            <i class="fas fa-phone me-2"></i>
                            <a href="tel:{{ $lowongan->kontak_telepon }}">{{ $lowongan->kontak_telepon }}</a>
                        </div>
                        @endif
                    </div>
                </div>
                @endif

                <!-- Quick Actions -->
                <div class="d-flex gap-2 flex-wrap">
                    @if($lowongan->status == 'aktif')
                        <button class="btn btn-outline-warning btn-sm" onclick="toggleStatus('nonaktif')">
                            <i class="fas fa-pause"></i> Nonaktifkan
                        </button>
                    @else
                        <button class="btn btn-outline-success btn-sm" onclick="toggleStatus('aktif')">
                            <i class="fas fa-play"></i> Aktifkan
                        </button>
                    @endif
                    
                    <button class="btn btn-outline-info btn-sm" onclick="copyJobLink()">
                        <i class="fas fa-link"></i> Salin Link
                    </button>
                    
                    @if($lowongan->kontak_email)
                    <a href="mailto:{{ $lowongan->kontak_email }}?subject=Lowongan {{ $lowongan->posisi }}" class="btn btn-outline-primary btn-sm">
                        <i class="fas fa-envelope"></i> Email Kontak
                    </a>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Sidebar -->
    <div class="col-lg-4">
        <!-- Info Panel -->
        <div class="card mb-4">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-info"></i> Info Panel</h6>
            </div>
            <div class="card-body">
                <table class="table table-sm table-borderless">
                    <tr>
                        <td><strong>ID:</strong></td>
                        <td>{{ $lowongan->id }}</td>
                    </tr>
                    <tr>
                        <td><strong>Posisi:</strong></td>
                        <td>{{ $lowongan->posisi }}</td>
                    </tr>
                    <tr>
                        <td><strong>Perusahaan:</strong></td>
                        <td>{{ $lowongan->perusahaan }}</td>
                    </tr>
                    <tr>
                        <td><strong>Lokasi:</strong></td>
                        <td>{{ $lowongan->lokasi }}</td>
                    </tr>
                    <tr>
                        <td><strong>Tipe:</strong></td>
                        <td>
                            <span class="badge bg-info">{{ ucfirst(str_replace('_', ' ', $lowongan->tipe_pekerjaan)) }}</span>
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Status:</strong></td>
                        <td>
                            <span class="badge {{ $lowongan->status == 'aktif' ? 'bg-success' : ($lowongan->status == 'expired' ? 'bg-danger' : 'bg-secondary') }}">
                                {{ ucfirst($lowongan->status) }}
                            </span>
                        </td>
                    </tr>
                    @if($lowongan->deadline)
                    <tr>
                        <td><strong>Deadline:</strong></td>
                        <td>{{ $lowongan->deadline->format('d/m/Y') }}</td>
                    </tr>
                    @endif
                    <tr>
                        <td><strong>Dibuat:</strong></td>
                        <td>{{ $lowongan->created_at->format('d/m/Y H:i') }}</td>
                    </tr>
                    <tr>
                        <td><strong>Diupdate:</strong></td>
                        <td>{{ $lowongan->updated_at->format('d/m/Y H:i') }}</td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="card mb-4">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-cogs"></i> Aksi</h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('admin.lowongan.edit', $lowongan->id) }}" class="btn btn-warning">
                        <i class="fas fa-edit"></i> Edit Lowongan
                    </a>
                    
                    <button class="btn btn-info" onclick="viewOnWebsite()">
                        <i class="fas fa-external-link-alt"></i> Lihat di Website
                    </button>
                    
                    <button class="btn btn-danger" onclick="confirmDelete()">
                        <i class="fas fa-trash"></i> Hapus Lowongan
                    </button>
                    
                    <hr>
                    
                    <a href="{{ route('admin.lowongan.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Kembali ke Daftar
                    </a>
                </div>
            </div>
        </div>

        <!-- SEO Information -->
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-search"></i> Informasi SEO</h6>
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <label class="form-label small">Meta Title:</label>
                    <div class="bg-light p-2 rounded small">
                        Lowongan {{ $lowongan->posisi }} di {{ $lowongan->perusahaan }}
                    </div>
                </div>
                
                <div class="mb-3">
                    <label class="form-label small">Meta Description:</label>
                    <div class="bg-light p-2 rounded small">
                        {{ Str::limit($lowongan->deskripsi_singkat, 150) }}
                    </div>
                </div>
                
                <div class="mb-3">
                    <label class="form-label small">Keywords:</label>
                    <div class="bg-light p-2 rounded small">
                        lowongan kerja, {{ strtolower($lowongan->posisi) }}, {{ strtolower($lowongan->perusahaan) }}, {{ strtolower($lowongan->lokasi) }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Navigation -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        {{-- Previous job navigation will be implemented when needed --}}
                        <button class="btn btn-outline-secondary btn-sm" disabled>
                            <i class="fas fa-chevron-left"></i> Lowongan Sebelumnya
                        </button>
                    </div>
                    
                    <div>
                        <a href="{{ route('admin.lowongan.index') }}" class="btn btn-primary">
                            <i class="fas fa-list"></i> Semua Lowongan
                        </a>
                    </div>
                    
                    <div>
                        {{-- Next job navigation will be implemented when needed --}}
                        <button class="btn btn-outline-secondary btn-sm" disabled>
                            Lowongan Selanjutnya <i class="fas fa-chevron-right"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Hidden form for status toggle -->
<form id="statusForm" action="{{ route('admin.lowongan.update', $lowongan->id) }}" method="POST" style="display: none;">
    @csrf
    @method('PUT')
    <input type="hidden" name="status" id="statusInput">
    <input type="hidden" name="posisi" value="{{ $lowongan->posisi }}">
    <input type="hidden" name="perusahaan" value="{{ $lowongan->perusahaan }}">
    <input type="hidden" name="lokasi" value="{{ $lowongan->lokasi }}">
    <input type="hidden" name="deskripsi_singkat" value="{{ $lowongan->deskripsi_singkat }}">
    <input type="hidden" name="persyaratan" value="{{ $lowongan->persyaratan }}">
    <input type="hidden" name="gaji_min" value="{{ $lowongan->gaji_min }}">
    <input type="hidden" name="gaji_max" value="{{ $lowongan->gaji_max }}">
    <input type="hidden" name="tipe_pekerjaan" value="{{ $lowongan->tipe_pekerjaan }}">
    <input type="hidden" name="deadline" value="{{ $lowongan->deadline ? $lowongan->deadline->format('Y-m-d') : '' }}">
    <input type="hidden" name="kontak_nama" value="{{ $lowongan->kontak_nama }}">
    <input type="hidden" name="kontak_email" value="{{ $lowongan->kontak_email }}">
    <input type="hidden" name="kontak_telepon" value="{{ $lowongan->kontak_telepon }}">
</form>

<!-- Hidden form for delete -->
<form id="deleteForm" action="{{ route('admin.lowongan.destroy', $lowongan->id) }}" method="POST" style="display: none;">
    @csrf
    @method('DELETE')
</form>

<script>
function toggleStatus(newStatus) {
    if (confirm('Apakah Anda yakin ingin mengubah status lowongan ini?')) {
        document.getElementById('statusInput').value = newStatus;
        document.getElementById('statusForm').submit();
    }
}

function confirmDelete() {
    if (confirm('Apakah Anda yakin ingin menghapus lowongan ini?\n\nPosisi: {{ $lowongan->posisi }}\nPerusahaan: {{ $lowongan->perusahaan }}\n\nTindakan ini tidak dapat dibatalkan!')) {
        document.getElementById('deleteForm').submit();
    }
}

function copyJobLink() {
    // This would be the actual job URL on the website
    const jobUrl = `${window.location.origin}/lowongan/{{ $lowongan->id }}`;
    
    navigator.clipboard.writeText(jobUrl).then(function() {
        alert('Link lowongan berhasil disalin ke clipboard!');
    }, function(err) {
        console.error('Gagal menyalin link: ', err);
        alert('Gagal menyalin link ke clipboard.');
    });
}

function viewOnWebsite() {
    // This would open the job on the public website
    const jobUrl = `${window.location.origin}/lowongan/{{ $lowongan->id }}`;
    window.open(jobUrl, '_blank');
}

// Auto-refresh deadline status if needed
document.addEventListener('DOMContentLoaded', function() {
    // Check if deadline has passed and update status accordingly
    @if($lowongan->deadline && $lowongan->deadline->isPast() && $lowongan->status == 'aktif')
        if (confirm('Lowongan ini sudah melewati deadline. Apakah Anda ingin mengubah status menjadi expired?')) {
            toggleStatus('expired');
        }
    @endif
});
</script>
@endsection