@extends('admin.layout')

@section('title', 'Manajemen Produk')
@section('page-title', 'Manajemen Produk')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-box"></i> Daftar Produk</h5>
                <a href="{{ route('admin.produk.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Tambah Produk
                </a>
            </div>
            <div class="card-body">
                @if($produk->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th width="5%">#</th>
                                    <th width="15%">Gambar</th>
                                    <th width="25%">Nama Produk</th>
                                    <th width="15%">Harga</th>
                                    <th width="10%">Stok</th>
                                    <th width="10%">Status</th>
                                    <th width="10%">Tanggal</th>
                                    <th width="10%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($produk as $index => $item)
                                    <tr>
                                        <td>{{ $produk->firstItem() + $index }}</td>
                                        <td>
                                            @php
                                                $img = $item->gambar;
                                                if (is_array($img)) {
                                                    $img = $img[0] ?? null;
                                                }
                                            @endphp
                                            @if(!empty($img))
                                                <img src="{{ asset('storage/' . $img) }}" 
                                                     alt="{{ $item->nama }}" 
                                                     class="img-thumbnail" 
                                                     style="width: 60px; height: 60px; object-fit: cover;">
                                            @else
                                                <div class="bg-light d-flex align-items-center justify-content-center" 
                                                     style="width: 60px; height: 60px;">
                                                    <i class="fas fa-image text-muted"></i>
                                                </div>
                                            @endif
                                        </td>
                                        <td>
                                            <h6 class="mb-1">{{ Str::limit($item->nama, 40) }}</h6>
                                            <small class="text-muted">{{ Str::limit($item->deskripsi, 60) }}</small>
                                        </td>
                                        <td>
                                            <strong class="text-success">Rp {{ number_format($item->harga, 0, ',', '.') }}</strong>
                                        </td>
                                        <td>
                                            <span class="badge bg-{{ $item->stok > 10 ? 'success' : ($item->stok > 0 ? 'warning' : 'danger') }}">
                                                {{ $item->stok }}
                                            </span>
                                        </td>
                                        <td>
                                            <span class="badge bg-{{ $item->status == 'aktif' ? 'success' : 'secondary' }}">
                                                {{ ucfirst($item->status) }}
                                            </span>
                                        </td>
                                        <td>
                                            <small>{{ $item->created_at->format('d M Y') }}</small>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('admin.produk.show', $item->id) }}" 
                                                   class="btn btn-sm btn-info" title="Lihat">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('admin.produk.edit', $item->id) }}" 
                                                   class="btn btn-sm btn-warning" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('admin.produk.destroy', $item->id) }}" 
                                                      method="POST" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger" 
                                                            title="Hapus"
                                                            onclick="return confirm('Yakin ingin menghapus produk ini?')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="d-flex justify-content-center">
                        {{ $produk->links() }}
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="fas fa-box fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">Belum ada produk</h5>
                        <p class="text-muted">Mulai dengan menambahkan produk pertama Anda</p>
                        <a href="{{ route('admin.produk.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Tambah Produk
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Quick Stats -->
<div class="row mt-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ $produk->total() }}</h4>
                        <p class="mb-0">Total Produk</p>
                    </div>
                    <i class="fas fa-box fa-2x opacity-75"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ \App\Models\Produk::where('status', 'aktif')->count() }}</h4>
                        <p class="mb-0">Produk Aktif</p>
                    </div>
                    <i class="fas fa-check-circle fa-2x opacity-75"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ \App\Models\Produk::where('stok', '<=', 10)->where('stok', '>', 0)->count() }}</h4>
                        <p class="mb-0">Stok Menipis</p>
                    </div>
                    <i class="fas fa-exclamation-triangle fa-2x opacity-75"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-danger text-white">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4>{{ \App\Models\Produk::where('stok', 0)->count() }}</h4>
                        <p class="mb-0">Stok Habis</p>
                    </div>
                    <i class="fas fa-times-circle fa-2x opacity-75"></i>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection