@extends('admin.layout')

@section('title', 'Detail Produk')
@section('page-title', 'Detail Produk')

@section('content')
<div class="row">
    <!-- Main Content -->
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-box"></i> {{ $produk->nama }}</h5>
                <span class="badge bg-{{ $produk->status == 'aktif' ? 'success' : 'secondary' }} fs-6">
                    {{ ucfirst($produk->status) }}
                </span>
            </div>
            <div class="card-body">
                <!-- Gambar Produk -->
                @php
                    $img = $produk->gambar;
                    if (is_array($img)) {
                        $img = $img[0] ?? null;
                    }
                @endphp
                @if(!empty($img))
                    <div class="text-center mb-4">
                        <img src="{{ asset('storage/' . $img) }}" 
                             alt="{{ $produk->nama }}" 
                             class="img-fluid rounded shadow"
                             style="max-height: 400px; object-fit: cover;">
                    </div>
                @else
                    <div class="text-center mb-4">
                        <div class="bg-light d-flex align-items-center justify-content-center rounded" 
                             style="height: 300px;">
                            <div class="text-muted">
                                <i class="fas fa-image fa-3x mb-2"></i>
                                <p>Tidak ada gambar</p>
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Informasi Harga dan Stok -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <div class="card bg-success text-white">
                            <div class="card-body text-center">
                                <h3 class="mb-0">Rp {{ number_format($produk->harga, 0, ',', '.') }}</h3>
                                <small>Harga Produk</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-{{ $produk->stok > 10 ? 'primary' : ($produk->stok > 0 ? 'warning' : 'danger') }} text-white">
                            <div class="card-body text-center">
                                <h3 class="mb-0">{{ $produk->stok }}</h3>
                                <small>Stok Tersedia</small>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Deskripsi -->
                @if($produk->deskripsi)
                    <div class="mb-4">
                        <h6><i class="fas fa-align-left"></i> Deskripsi Singkat</h6>
                        <p class="text-muted">{{ $produk->deskripsi }}</p>
                    </div>
                @endif

                <!-- Detail -->
                @if($produk->detail)
                    <div class="mb-4">
                        <h6><i class="fas fa-list-ul"></i> Detail Produk</h6>
                        <div class="bg-light p-3 rounded">
                            {!! nl2br(e($produk->detail)) !!}
                        </div>
                    </div>
                @endif

                <!-- Kontak Penjual -->
                @if($produk->penjual || $produk->kontak_penjual)
                    <div class="mb-4">
                        <h6><i class="fas fa-phone"></i> Kontak Penjual</h6>
                        <div class="row">
                            @if($produk->penjual)
                                <div class="col-md-6">
                                    <strong>Nama:</strong> {{ $produk->penjual }}
                                </div>
                            @endif
                            @if($produk->kontak_penjual)
                                <div class="col-md-6">
                                    <strong>HP/WhatsApp:</strong> 
                                    <a href="https://wa.me/{{ preg_replace('/[^0-9]/', '', $produk->kontak_penjual) }}" 
                                       target="_blank" class="text-success">
                                        {{ $produk->kontak_penjual }} <i class="fab fa-whatsapp"></i>
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>
                @endif

                <!-- Quick Actions -->
                <div class="d-flex gap-2 flex-wrap">
                    @if($produk->status == 'nonaktif')
                        <form action="{{ route('admin.produk.update', $produk->id) }}" method="POST" class="d-inline">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="status" value="aktif">
                            <input type="hidden" name="nama" value="{{ $produk->nama }}">
                            <input type="hidden" name="harga" value="{{ $produk->harga }}">
                            <input type="hidden" name="stok" value="{{ $produk->stok }}">
                            <button type="submit" class="btn btn-success btn-sm">
                                <i class="fas fa-check"></i> Aktifkan
                            </button>
                        </form>
                    @else
                        <form action="{{ route('admin.produk.update', $produk->id) }}" method="POST" class="d-inline">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="status" value="nonaktif">
                            <input type="hidden" name="nama" value="{{ $produk->nama }}">
                            <input type="hidden" name="harga" value="{{ $produk->harga }}">
                            <input type="hidden" name="stok" value="{{ $produk->stok }}">
                            <button type="submit" class="btn btn-warning btn-sm">
                                <i class="fas fa-pause"></i> Nonaktifkan
                            </button>
                        </form>
                    @endif
                    
                    <button type="button" class="btn btn-info btn-sm" onclick="copyLink()">
                        <i class="fas fa-link"></i> Salin Link
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Sidebar Info -->
    <div class="col-lg-4">
        <!-- Info Panel -->
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-info-circle"></i> Informasi Produk</h6>
            </div>
            <div class="card-body">
                <table class="table table-sm">
                    <tr>
                        <td><strong>ID:</strong></td>
                        <td>{{ $produk->id }}</td>
                    </tr>
                    @if($produk->kategori)
                        <tr>
                            <td><strong>Kategori:</strong></td>
                            <td>
                                <span class="badge bg-secondary">{{ ucfirst($produk->kategori) }}</span>
                            </td>
                        </tr>
                    @endif
                    <tr>
                        <td><strong>Status:</strong></td>
                        <td>
                            <span class="badge bg-{{ $produk->status == 'aktif' ? 'success' : 'secondary' }}">
                                {{ ucfirst($produk->status) }}
                            </span>
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Dibuat:</strong></td>
                        <td>{{ $produk->created_at->format('d M Y H:i') }}</td>
                    </tr>
                    <tr>
                        <td><strong>Diupdate:</strong></td>
                        <td>{{ $produk->updated_at->format('d M Y H:i') }}</td>
                    </tr>
                </table>
            </div>
        </div>

        <!-- Actions -->
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-cogs"></i> Aksi</h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('admin.produk.edit', $produk->id) }}" class="btn btn-warning">
                        <i class="fas fa-edit"></i> Edit Produk
                    </a>
                    
                    <a href="{{ route('produk') }}#produk-{{ $produk->id }}" 
                       target="_blank" class="btn btn-info">
                        <i class="fas fa-external-link-alt"></i> Lihat di Website
                    </a>
                    
                    <form action="{{ route('admin.produk.destroy', $produk->id) }}" 
                          method="POST" 
                          onsubmit="return confirm('Yakin ingin menghapus produk ini?')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger w-100">
                            <i class="fas fa-trash"></i> Hapus Produk
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- SEO Info -->
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-search"></i> Informasi SEO</h6>
            </div>
            <div class="card-body">
                <small class="text-muted">
                    <strong>URL:</strong><br>
                    <code>{{ url('/produk#produk-' . $produk->id) }}</code>
                </small>
                
                @if($produk->deskripsi)
                    <hr>
                    <small class="text-muted">
                        <strong>Meta Description:</strong><br>
                        {{ Str::limit($produk->deskripsi, 160) }}
                    </small>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Navigation -->
<div class="row mt-4">
    <div class="col-12">
        <div class="d-flex justify-content-between">
            <a href="{{ route('admin.produk.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Kembali ke Daftar
            </a>
            
            <div>
                @php
                    $prevProduk = \App\Models\Produk::where('id', '<', $produk->id)->orderBy('id', 'desc')->first();
                    $nextProduk = \App\Models\Produk::where('id', '>', $produk->id)->orderBy('id', 'asc')->first();
                @endphp
                
                @if($prevProduk)
                    <a href="{{ route('admin.produk.show', $prevProduk->id) }}" 
                       class="btn btn-outline-secondary me-2" title="Produk Sebelumnya">
                        <i class="fas fa-chevron-left"></i> {{ Str::limit($prevProduk->nama, 20) }}
                    </a>
                @endif
                
                @if($nextProduk)
                    <a href="{{ route('admin.produk.show', $nextProduk->id) }}" 
                       class="btn btn-outline-secondary" title="Produk Selanjutnya">
                        {{ Str::limit($nextProduk->nama, 20) }} <i class="fas fa-chevron-right"></i>
                    </a>
                @endif
            </div>
        </div>
    </div>
</div>

<script>
function copyLink() {
    const url = "{{ url('/produk#produk-' . $produk->id) }}";
    navigator.clipboard.writeText(url).then(function() {
        // Show success message
        const btn = event.target.closest('button');
        const originalText = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-check"></i> Tersalin!';
        btn.classList.remove('btn-info');
        btn.classList.add('btn-success');
        
        setTimeout(function() {
            btn.innerHTML = originalText;
            btn.classList.remove('btn-success');
            btn.classList.add('btn-info');
        }, 2000);
    });
}
</script>
@endsection