@extends('admin.layout')

@section('title', 'Manajemen Profil Desa')
@section('page-title', 'Manajemen Profil Desa')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-building"></i> Profil Desa</h5>
                @if(!$profil)
                    <a href="{{ route('admin.profil.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Buat Profil Desa
                    </a>
                @endif
            </div>
            <div class="card-body">
                @if($profil)
                    <div class="row">
                        <div class="col-md-8">
                            <h4>{{ $profil->nama_desa }}</h4>
                            <p class="text-muted mb-3">{{ $profil->alamat }}, {{ $profil->kecamatan }}, {{ $profil->kabupaten }}, {{ $profil->provinsi }}</p>
                            
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <h6><i class="fas fa-eye"></i> Visi</h6>
                                    <p class="text-muted">{{ Str::limit($profil->visi, 150) }}</p>
                                </div>
                                <div class="col-md-6">
                                    <h6><i class="fas fa-bullseye"></i> Misi</h6>
                                    <p class="text-muted">{{ Str::limit($profil->misi, 150) }}</p>
                                </div>
                            </div>

                            <div class="row mb-4">
                                <div class="col-md-3">
                                    <div class="card bg-primary text-white">
                                        <div class="card-body text-center">
                                            <h5>{{ number_format($profil->luas_wilayah ?? 0, 2) }}</h5>
                                            <small>Luas Wilayah (km²)</small>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card bg-success text-white">
                                        <div class="card-body text-center">
                                            <h5>{{ number_format($profil->jumlah_dusun ?? 0) }}</h5>
                                            <small>Jumlah Dusun</small>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card bg-info text-white">
                                        <div class="card-body text-center">
                                            <h5>{{ number_format($profil->jumlah_rw ?? 0) }}</h5>
                                            <small>Rukun Warga (RW)</small>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card bg-warning text-white">
                                        <div class="card-body text-center">
                                            <h5>{{ number_format($profil->jumlah_rt ?? 0) }}</h5>
                                            <small>Rukun Tetangga (RT)</small>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <h6><i class="fas fa-user"></i> Sambutan Kepala Desa</h6>
                            <div class="row align-items-start mb-4">
                                <div class="col-md-3">
                                    <div class="text-center">
                                        @if($profil->foto_kepala_desa)
                                            <img src="{{ asset('storage/' . $profil->foto_kepala_desa) }}" 
                                                 class="rounded-circle mb-2" 
                                                 style="width: 80px; height: 80px; object-fit: cover;">
                                        @else
                                            <div class="bg-light rounded-circle mx-auto mb-2 d-flex align-items-center justify-content-center" 
                                                 style="width: 80px; height: 80px;">
                                                <i class="fas fa-user text-muted"></i>
                                            </div>
                                        @endif
                                        <h6 class="mb-0">{{ $profil->kepala_desa }}</h6>
                                        <small class="text-muted">Kepala Desa</small>
                                    </div>
                                </div>
                                <div class="col-md-9">
                                    @if($profil->sambutan_kepala_desa)
                                        <p class="text-muted">{{ $profil->sambutan_kepala_desa }}</p>
                                    @else
                                        <p class="text-muted">Belum ada sambutan dari Kepala Desa.</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            @if($profil->logo_desa)
                                <div class="text-center mb-3">
                                    <img src="{{ asset('storage/' . $profil->logo_desa) }}" 
                                         alt="Logo Desa" 
                                         class="img-fluid" 
                                         style="max-height: 150px;">
                                </div>
                            @endif
                            
                            @if($profil->foto_kantor)
                                <div class="text-center mb-3">
                                    <img src="{{ asset('storage/' . $profil->foto_kantor) }}" 
                                         alt="Kantor Desa" 
                                         class="img-fluid rounded" 
                                         style="max-height: 200px;">
                                </div>
                            @endif

                            <div class="d-grid gap-2">
                                <a href="{{ route('admin.profil.edit', $profil->id) }}" class="btn btn-warning">
                                    <i class="fas fa-edit"></i> Edit Profil
                                </a>
                                <a href="{{ route('profil') }}" target="_blank" class="btn btn-info">
                                    <i class="fas fa-eye"></i> Lihat Halaman Publik
                                </a>
                            </div>
                        </div>
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="fas fa-building fa-3x text-muted mb-3"></i>
                        <h5>Belum Ada Profil Desa</h5>
                        <p class="text-muted">Silakan buat profil desa terlebih dahulu untuk menampilkan informasi desa.</p>
                        <a href="{{ route('admin.profil.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Buat Profil Desa
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
