@extends('admin.layout')

@section('title', 'Detail Profil Desa')
@section('page-title', 'Detail Profil Desa')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-eye"></i> Detail Profil Desa</h5>
                <div>
                    <a href="{{ route('admin.profil.edit', $profil->id) }}" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit"></i> Edit
                    </a>
                    <a href="{{ route('profil') }}" target="_blank" class="btn btn-info btn-sm">
                        <i class="fas fa-external-link-alt"></i> Lihat Halaman Publik
                    </a>
                </div>
            </div>
            <div class="card-body">
                <!-- Status -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="alert {{ $profil->is_active ? 'alert-success' : 'alert-warning' }}">
                            <i class="fas {{ $profil->is_active ? 'fa-check-circle' : 'fa-exclamation-triangle' }}"></i>
                            Status: {{ $profil->is_active ? 'Aktif' : 'Tidak Aktif' }}
                        </div>
                    </div>
                </div>

                <!-- Informasi Dasar -->
                <div class="row mb-4">
                    <div class="col-12">
                        <h6 class="border-bottom pb-2 mb-3"><i class="fas fa-info-circle"></i> Informasi Dasar</h6>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td width="40%"><strong>Nama Desa:</strong></td>
                                <td>{{ $profil->nama_desa }}</td>
                            </tr>
                            <tr>
                                <td><strong>Kecamatan:</strong></td>
                                <td>{{ $profil->kecamatan }}</td>
                            </tr>
                            <tr>
                                <td><strong>Kabupaten:</strong></td>
                                <td>{{ $profil->kabupaten }}</td>
                            </tr>
                            <tr>
                                <td><strong>Provinsi:</strong></td>
                                <td>{{ $profil->provinsi }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td width="40%"><strong>Alamat:</strong></td>
                                <td>{{ $profil->alamat }}</td>
                            </tr>
                            <tr>
                                <td><strong>Kode Pos:</strong></td>
                                <td>{{ $profil->kode_pos ?: '-' }}</td>
                            </tr>
                            <tr>
                                <td><strong>Telepon:</strong></td>
                                <td>{{ $profil->telepon ?: '-' }}</td>
                            </tr>
                            <tr>
                                <td><strong>Email:</strong></td>
                                <td>{{ $profil->email ?: '-' }}</td>
                            </tr>
                        </table>
                    </div>
                </div>

                <!-- Statistik -->
                <div class="row mb-4">
                    <div class="col-12">
                        <h6 class="border-bottom pb-2 mb-3"><i class="fas fa-chart-bar"></i> Statistik Desa</h6>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-primary text-white">
                            <div class="card-body text-center">
                                <h4>{{ number_format($profil->luas_wilayah, 2) ?? '-' }}</h4>
                                <p class="mb-0">Luas Wilayah (km²)</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-success text-white">
                            <div class="card-body text-center">
                                <h4>{{ number_format($profil->jumlah_dusun) ?? '-' }}</h4>
                                <p class="mb-0">Jumlah Dusun</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-info text-white">
                            <div class="card-body text-center">
                                <h4>{{ number_format($profil->jumlah_rw) ?? '-' }}</h4>
                                <p class="mb-0">Rukun Warga (RW)</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-warning text-white">
                            <div class="card-body text-center">
                                <h4>{{ number_format($profil->jumlah_rt) ?? '-' }}</h4>
                                <p class="mb-0">Rukun Tetangga (RT)</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Visi Misi -->
                <div class="row mb-4">
                    <div class="col-12">
                        <h6 class="border-bottom pb-2 mb-3"><i class="fas fa-eye"></i> Visi & Misi</h6>
                    </div>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h6 class="mb-0">Visi</h6>
                            </div>
                            <div class="card-body">
                                <p>{{ $profil->visi }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h6 class="mb-0">Misi</h6>
                            </div>
                            <div class="card-body">
                                <p>{{ $profil->misi }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 mt-3">
                        <div class="card">
                            <div class="card-header">
                                <h6 class="mb-0">Sejarah Desa</h6>
                            </div>
                            <div class="card-body">
                                <p>{{ $profil->sejarah }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Sambutan Kepala Desa -->
                <div class="row mb-4">
                    <div class="col-12">
                        <h6 class="border-bottom pb-2 mb-3"><i class="fas fa-users"></i> Sambutan Kepala Desa</h6>
                    </div>
                    
                    <!-- Kepala Desa -->
                    <div class="col-md-6 mb-3">
                        <div class="card">
                            <div class="card-body text-center">
                                @if($profil->foto_kepala_desa)
                                    <img src="{{ asset('storage/' . $profil->foto_kepala_desa) }}" 
                                         alt="Foto Kepala Desa" class="img-fluid rounded-circle mb-3" 
                                         style="width: 100px; height: 100px; object-fit: cover;">
                                @else
                                    <div class="bg-secondary rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" 
                                         style="width: 100px; height: 100px;">
                                        <i class="fas fa-user fa-2x text-white"></i>
                                    </div>
                                @endif
                                <h6>{{ $profil->kepala_desa }}</h6>
                                <p class="text-muted mb-0">Kepala Desa</p>
                            </div>
                        </div>
                    </div>

                    <!-- Sekretaris Desa -->
                    @if($profil->sekdes)
                    <div class="col-md-6 mb-3">
                        <div class="card">
                            <div class="card-body text-center">
                                @if($profil->foto_sekdes)
                                    <img src="{{ asset('storage/' . $profil->foto_sekdes) }}" 
                                         alt="Foto Sekdes" class="img-fluid rounded-circle mb-3" 
                                         style="width: 100px; height: 100px; object-fit: cover;">
                                @else
                                    <div class="bg-secondary rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" 
                                         style="width: 100px; height: 100px;">
                                        <i class="fas fa-user fa-2x text-white"></i>
                                    </div>
                                @endif
                                <h6>{{ $profil->sekdes }}</h6>
                                <p class="text-muted mb-0">Sekretaris Desa</p>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- BKD -->
                    @if($profil->bkd)
                    <div class="col-md-6 mb-3">
                        <div class="card">
                            <div class="card-body text-center">
                                @if($profil->foto_bkd)
                                    <img src="{{ asset('storage/' . $profil->foto_bkd) }}" 
                                         alt="Foto BKD" class="img-fluid rounded-circle mb-3" 
                                         style="width: 100px; height: 100px; object-fit: cover;">
                                @else
                                    <div class="bg-secondary rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" 
                                         style="width: 100px; height: 100px;">
                                        <i class="fas fa-user fa-2x text-white"></i>
                                    </div>
                                @endif
                                <h6>{{ $profil->bkd }}</h6>
                                <p class="text-muted mb-0">BKD</p>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Bendahara -->
                    @if($profil->bendahara)
                    <div class="col-md-6 mb-3">
                        <div class="card">
                            <div class="card-body text-center">
                                @if($profil->foto_bendahara)
                                    <img src="{{ asset('storage/' . $profil->foto_bendahara) }}" 
                                         alt="Foto Bendahara" class="img-fluid rounded-circle mb-3" 
                                         style="width: 100px; height: 100px; object-fit: cover;">
                                @else
                                    <div class="bg-secondary rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" 
                                         style="width: 100px; height: 100px;">
                                        <i class="fas fa-user fa-2x text-white"></i>
                                    </div>
                                @endif
                                <h6>{{ $profil->bendahara }}</h6>
                                <p class="text-muted mb-0">Bendahara</p>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>

                <!-- Media -->
                <div class="row mb-4">
                    <div class="col-12">
                        <h6 class="border-bottom pb-2 mb-3"><i class="fas fa-images"></i> Media</h6>
                    </div>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h6 class="mb-0">Logo Desa</h6>
                            </div>
                            <div class="card-body text-center">
                                @if($profil->logo_desa)
                                    <img src="{{ asset('storage/' . $profil->logo_desa) }}" 
                                         alt="Logo Desa" class="img-fluid" style="max-height: 200px;">
                                @else
                                    <div class="bg-light p-4 rounded">
                                        <i class="fas fa-image fa-3x text-muted"></i>
                                        <p class="text-muted mt-2">Tidak ada logo</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h6 class="mb-0">Foto Kantor Desa</h6>
                            </div>
                            <div class="card-body text-center">
                                @if($profil->foto_kantor)
                                    <img src="{{ asset('storage/' . $profil->foto_kantor) }}" 
                                         alt="Foto Kantor" class="img-fluid" style="max-height: 200px;">
                                @else
                                    <div class="bg-light p-4 rounded">
                                        <i class="fas fa-building fa-3x text-muted"></i>
                                        <p class="text-muted mt-2">Tidak ada foto kantor</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-between">
                    <a href="{{ route('admin.profil.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Kembali
                    </a>
                    <div>
                        <a href="{{ route('admin.profil.edit', $profil->id) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> Edit Profil
                        </a>
                        <a href="{{ route('profil') }}" target="_blank" class="btn btn-info">
                            <i class="fas fa-external-link-alt"></i> Lihat Halaman Publik
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
