@extends('admin.layout')

@section('title', 'Tambah Staf Desa')

@section('content')
<div class="content-wrapper">
    <div class="card">
        <div class="card-header">
            <h4>Tambah Staf</h4>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.staf.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="mb-3">
                    <label class="form-label">Nama</label>
                    <input type="text" name="nama" class="form-control" value="{{ old('nama') }}" required>
                    @error('nama')<small class="text-danger">{{ $message }}</small>@enderror
                </div>
                <div class="mb-3">
                    <label class="form-label">Jabatan</label>
                    <input type="text" name="jabatan" class="form-control" value="{{ old('jabatan') }}" required>
                    @error('jabatan')<small class="text-danger">{{ $message }}</small>@enderror
                </div>
                <div class="mb-3">
                    <label class="form-label">Foto (opsional)</label>
                    <input type="file" name="foto" class="form-control" accept="image/*">
                    @error('foto')<small class="text-danger">{{ $message }}</small>@enderror
                </div>
                <div class="d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.staf.index') }}" class="btn btn-secondary">Batal</a>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection