@extends('admin.layout')

@section('title', 'Edit Staf Desa')

@section('content')
<div class="content-wrapper">
    <div class="card">
        <div class="card-header">
            <h4>Edit Staf</h4>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.staf.update', $index) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="mb-3">
                    <label class="form-label">Nama</label>
                    <input type="text" name="nama" class="form-control" value="{{ old('nama', $item['nama'] ?? '') }}" required>
                    @error('nama')<small class="text-danger">{{ $message }}</small>@enderror
                </div>
                <div class="mb-3">
                    <label class="form-label">Jabatan</label>
                    <input type="text" name="jabatan" class="form-control" value="{{ old('jabatan', $item['jabatan'] ?? '') }}" required>
                    @error('jabatan')<small class="text-danger">{{ $message }}</small>@enderror
                </div>
                <div class="mb-3">
                    <label class="form-label">Foto (opsional)</label>
                    @if(!empty($item['foto']))
                        <div class="mb-2">
                            <img src="{{ asset('storage/' . $item['foto']) }}" alt="Foto" style="height:120px;object-fit:cover;" class="rounded">
                        </div>
                    @endif
                    <input type="file" name="foto" class="form-control" accept="image/*">
                    @error('foto')<small class="text-danger">{{ $message }}</small>@enderror
                </div>
                <div class="d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.staf.index') }}" class="btn btn-secondary">Batal</a>
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection