@extends('layouts.app')
@section('title', 'Lowongan Kerja Karangtaruna')
@section('content')

<!-- Header -->
<section class="relative bg-gradient-to-br from-green-800 via-green-700 to-green-600 text-white py-16 md:py-24 shadow-xl">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
    <div class="mb-6">
      <span class="inline-block px-4 py-2 bg-green-500/20 text-green-100 rounded-full text-sm font-medium mb-4">
        💼 Karir & Peluang
      </span>
    </div>
    <h1 class="text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-extrabold mb-6 leading-tight">
      Lowongan Kerja <span class="text-green-300">Terbaru</span>
    </h1>
    <p class="text-lg md:text-xl lg:text-2xl opacity-90 max-w-3xl mx-auto leading-relaxed">
      Temukan berbagai peluang karir menarik di sekitar Kecamatan Beji, Kabupaten Pasuruan bersama mitra Karangtaruna
    </p>
    <div class="mt-8 flex flex-col sm:flex-row gap-4 justify-center">
      <div class="flex items-center justify-center text-green-200">
        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
          <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
        </svg>
        <span class="text-sm font-medium">Terpercaya</span>
      </div>
      <div class="flex items-center justify-center text-green-200">
        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
          <path d="M13 6a3 3 0 11-6 0 3 3 0 016 0zM18 8a2 2 0 11-4 0 2 2 0 014 0zM14 15a4 4 0 00-8 0v3h8v-3z"></path>
        </svg>
        <span class="text-sm font-medium">Lokal</span>
      </div>
      <div class="flex items-center justify-center text-green-200">
        <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
          <path d="M3 4a1 1 0 011-1h12a1 1 0 011 1v2a1 1 0 01-1 1H4a1 1 0 01-1-1V4zM3 10a1 1 0 011-1h6a1 1 0 011 1v6a1 1 0 01-1 1H4a1 1 0 01-1-1v-6zM14 9a1 1 0 00-1 1v6a1 1 0 001 1h2a1 1 0 001-1v-6a1 1 0 00-1-1h-2z"></path>
        </svg>
        <span class="text-sm font-medium">Beragam Posisi</span>
      </div>
    </div>
  </div>
  <div class="absolute bottom-0 left-0 right-0">
    <svg class="w-full h-12 md:h-16 text-white" viewBox="0 0 1440 320" preserveAspectRatio="none" fill="currentColor">
      <path d="M0,160L48,170.7C96,181,192,203,288,218.7C384,235,480,245,576,245.3C672,245,768,235,864,224C960,213,1056,203,1152,181.3C1248,160,1344,128,1392,112L1440,96L1440,320L0,320Z"></path>
    </svg>
  </div>
</section>

<!-- Stats Section -->
<section class="bg-green-50 py-8 md:py-12">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="grid grid-cols-2 md:grid-cols-4 gap-4 md:gap-8">
      <div class="text-center">
        <div class="text-2xl md:text-3xl font-bold text-green-800">8+</div>
        <div class="text-sm md:text-base text-green-600 font-medium">Lowongan Aktif</div>
      </div>
      <div class="text-center">
        <div class="text-2xl md:text-3xl font-bold text-green-800">50+</div>
        <div class="text-sm md:text-base text-green-600 font-medium">Pelamar Berhasil</div>
      </div>
      <div class="text-center">
        <div class="text-2xl md:text-3xl font-bold text-green-800">15+</div>
        <div class="text-sm md:text-base text-green-600 font-medium">Perusahaan Mitra</div>
      </div>
      <div class="text-center">
        <div class="text-2xl md:text-3xl font-bold text-green-800">100%</div>
        <div class="text-sm md:text-base text-green-600 font-medium">Gratis</div>
      </div>
    </div>
  </div>
</section>

<!-- Daftar Lowongan -->
<section class="bg-gray-50 py-12 md:py-16">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="text-center mb-12">
      <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">Peluang Karir Terbuka</h2>
      <p class="text-gray-600 max-w-2xl mx-auto">Bergabunglah dengan perusahaan-perusahaan terpercaya yang bermitra dengan Karangtaruna</p>
    </div>
    
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6 md:gap-8">

    <!-- 1. Operator Produksi -->
    <div class="bg-white shadow-lg rounded-2xl overflow-hidden hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 border border-green-100">
      <div class="relative overflow-hidden">
        <img src="{{ asset('img/lowongan/op.jpg') }}" alt="Operator Produksi"
             class="w-full h-48 sm:h-40 lg:h-48 object-cover transition-transform duration-300 hover:scale-110">
        <div class="absolute top-3 right-3">
          <span class="bg-green-500 text-white px-2 py-1 rounded-full text-xs font-medium">Aktif</span>
        </div>
      </div>
      <div class="p-4 lg:p-5">
        <h4 class="font-bold text-lg lg:text-xl text-gray-800 mb-2 line-clamp-2">Operator Produksi</h4>
        <p class="text-gray-600 text-sm mb-3 line-clamp-3 leading-relaxed">Dibutuhkan operator produksi untuk pabrik makanan ringan. Lulusan minimal SMA/SMK.</p>
        <div class="flex items-center mb-4">
          <svg class="w-4 h-4 text-green-600 mr-2" fill="currentColor" viewBox="0 0 20 20">
            <path d="M8.433 7.418c.155-.103.346-.196.567-.267v1.698a2.305 2.305 0 01-.567-.267C8.07 8.34 8 8.114 8 8c0-.114.07-.34.433-.582zM11 12.849v-1.698c.22.071.412.164.567.267.364.243.433.468.433.582 0 .114-.07.34-.433.582a2.305 2.305 0 01-.567.267z"></path>
            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-13a1 1 0 10-2 0v.092a4.535 4.535 0 00-1.676.662C6.602 6.234 6 7.009 6 8c0 .99.602 1.765 1.324 2.246.48.32 1.054.545 1.676.662v1.941c-.391-.127-.68-.317-.843-.504a1 1 0 10-1.51 1.31c.562.649 1.413 1.076 2.353 1.253V15a1 1 0 102 0v-.092a4.535 4.535 0 001.676-.662C13.398 13.766 14 12.991 14 12c0-.99-.602-1.765-1.324-2.246A4.535 4.535 0 0011 9.092V7.151c.391.127.68.317.843.504a1 1 0 101.511-1.31c-.563-.649-1.413-1.076-2.354-1.253V5z" clip-rule="evenodd"></path>
          </svg>
          <span class="text-green-700 font-bold text-sm">Rp 2.500.000 - Rp 3.000.000</span>
        </div>
        <a href="{{ url('/lowongan/operator') }}" 
           class="block w-full bg-gradient-to-r from-green-600 to-green-700 text-white px-4 py-3 rounded-xl text-center hover:from-green-700 hover:to-green-800 transition-all duration-300 font-medium shadow-lg hover:shadow-xl">
           Lihat Detail
        </a>
      </div>
    </div>

    <!-- 2. Barista Kopi -->
    <div class="bg-white shadow rounded-xl overflow-hidden p-5 hover:scale-105 transition">
      <img src="{{ asset('img/lowongan/barista.webp') }}" alt="Barista Kopi"
           class="w-full h-40 object-cover rounded-md mb-3">
      <h4 class="font-semibold text-xl text-gray-800">Barista Kopi</h4>
      <p class="text-gray-600 text-sm mb-3">Cafe mitra Karangtaruna membuka lowongan Barista. Pengalaman tidak diutamakan.</p>
      <span class="text-green-700 font-bold text-sm">Gaji: Rp 2.000.000 + Tunjangan</span>
      <a href="{{ url('/lowongan/barista.') }}" 
         class="block mt-3 bg-green-700 text-white px-4 py-2 rounded-lg text-center hover:bg-green-800 transition">
         Lihat Detail
      </a>
    </div>

    <!-- 3. Admin Online Shop -->
    <div class="bg-white shadow rounded-xl overflow-hidden p-5 hover:scale-105 transition">
      <img src="{{ asset('img/lowongan/admin.png') }}" alt="Admin Online Shop"
           class="w-full h-40 object-cover rounded-md mb-3">
      <h4 class="font-semibold text-xl text-gray-800">Admin Online Shop</h4>
      <p class="text-gray-600 text-sm mb-3">Mengelola pesanan & chat customer di marketplace. Dibutuhkan teliti & komunikatif.</p>
      <span class="text-green-700 font-bold text-sm">Gaji: Rp 2.200.000</span>
      <a href="{{ url('/lowongan/admin') }}" 
         class="block mt-3 bg-green-700 text-white px-4 py-2 rounded-lg text-center hover:bg-green-800 transition">
         Lihat Detail
      </a>
    </div>

    <!-- 4. Sopir Logistik -->
    <div class="bg-white shadow rounded-xl overflow-hidden p-5 hover:scale-105 transition">
      <img src="{{ asset('img/lowongan/sopir.jpg') }}" alt="Sopir Logistik"
           class="w-full h-40 object-cover rounded-md mb-3">
      <h4 class="font-semibold text-xl text-gray-800">Sopir Logistik</h4>
      <p class="text-gray-600 text-sm mb-3">Perusahaan distribusi membuka lowongan sopir. Wajib SIM B1, pengalaman min. 1 tahun.</p>
      <span class="text-green-700 font-bold text-sm">Gaji: Rp 3.500.000</span>
      <a href="{{ url('/lowongan/sopir') }}" 
         class="block mt-3 bg-green-700 text-white px-4 py-2 rounded-lg text-center hover:bg-green-800 transition">
         Lihat Detail
      </a>
    </div>

    <!-- 5. Desainer Grafis -->
    <div class="bg-white shadow rounded-xl overflow-hidden p-5 hover:scale-105 transition">
      <img src="{{ asset('img/lowongan/desain.webp') }}" alt="Desainer Grafis"
           class="w-full h-40 object-cover rounded-md mb-3">
      <h4 class="font-semibold text-xl text-gray-800">Desainer Grafis</h4>
      <p class="text-gray-600 text-sm mb-3">Dibutuhkan desainer grafis untuk percetakan dan sablon. Menguasai CorelDRAW/Photoshop.</p>
      <span class="text-green-700 font-bold text-sm">Gaji: Rp 2.800.000</span>
      <a href="{{ url('/lowongan/desainer') }}" 
         class="block mt-3 bg-green-700 text-white px-4 py-2 rounded-lg text-center hover:bg-green-800 transition">
         Lihat Detail
      </a>
    </div>

    <!-- 6. Mekanik Motor -->
    <div class="bg-white shadow rounded-xl overflow-hidden p-5 hover:scale-105 transition">
      <img src="{{ asset('img/lowongan/mekanik.jpg') }}" alt="Mekanik Motor"
           class="w-full h-40 object-cover rounded-md mb-3">
      <h4 class="font-semibold text-xl text-gray-800">Mekanik Motor</h4>
      <p class="text-gray-600 text-sm mb-3">Bengkel mitra Karangtaruna membuka lowongan mekanik motor. Minimal pengalaman 6 bulan.</p>
      <span class="text-green-700 font-bold text-sm">Gaji: Rp 2.500.000</span>
      <a href="{{ url('/lowongan/mekanik') }}" 
         class="block mt-3 bg-green-700 text-white px-4 py-2 rounded-lg text-center hover:bg-green-800 transition">
         Lihat Detail
      </a>
    </div>

    <!-- 7. Penjahit Konveksi -->
    <div class="bg-white shadow rounded-xl overflow-hidden p-5 hover:scale-105 transition">
      <img src="{{ asset('img/lowongan/penjahit.jpg') }}" alt="Penjahit Konveksi"
           class="w-full h-40 object-cover rounded-md mb-3">
      <h4 class="font-semibold text-xl text-gray-800">Penjahit Konveksi</h4>
      <p class="text-gray-600 text-sm mb-3">Dibutuhkan penjahit untuk usaha konveksi lokal. Bisa mesin obras & jahit standar.</p>
      <span class="text-green-700 font-bold text-sm">Gaji: Rp 2.300.000</span>
      <a href="{{ url('/lowongan/penjahit') }}" 
         class="block mt-3 bg-green-700 text-white px-4 py-2 rounded-lg text-center hover:bg-green-800 transition">
         Lihat Detail
      </a>
    </div>

    <!-- 8. Staff Gudang -->
    <div class="bg-white shadow rounded-xl overflow-hidden p-5 hover:scale-105 transition">
      <img src="{{ asset('img/lowongan/gudang.webp') }}" alt="Staff Gudang"
           class="w-full h-40 object-cover rounded-md mb-3">
      <h4 class="font-semibold text-xl text-gray-800">Staff Gudang</h4>
      <p class="text-gray-600 text-sm mb-3">Perusahaan ekspedisi mencari staff gudang. Lulusan minimal SMA/SMK, siap kerja shift.</p>
      <span class="text-green-700 font-bold text-sm">Gaji: Rp 2.400.000</span>
      <a href="{{ url('/lowongan/gudang') }}" 
         class="block mt-3 bg-green-700 text-white px-4 py-2 rounded-lg text-center hover:bg-green-800 transition">
         Lihat Detail
      </a>
    </div>
  </div>
  <div class="mt-10 mb-10 text-center">
    <a href="{{ url('/lowongan') }}" style="background-color: #327A6D;" class="inline-flex items-center gap-2 px-6 py-3 text-white rounded hover:bg-green-700 transition text-sm font-semibold shadow">
      Lihat Semua Lowongan
      <i class="fas fa-arrow-right"></i>
    </a>
  </div>
</section>

@endsection
