<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\BeritaController;
use App\Http\Controllers\Admin\ProdukController;
use App\Http\Controllers\Admin\LowonganController;
use App\Http\Controllers\Admin\AnggaranController;
use App\Http\Controllers\Admin\DemografiController;
use App\Http\Controllers\Admin\ProfilDesaController;
use App\Http\Controllers\Admin\StafDesaController;

// Public Routes
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/tentang', [HomeController::class, 'tentang'])->name('tentang');
Route::get('/berita', [HomeController::class, 'berita'])->name('berita');
Route::get('/berita/{slug}', [HomeController::class, 'beritaDetail'])->name('berita.detail');
Route::get('/produk', [HomeController::class, 'produk'])->name('produk');
Route::get('/produk/{slug}', [HomeController::class, 'produkDetail'])->name('produk.detail');
Route::get('/lowongan', [HomeController::class, 'lowongan'])->name('lowongan');
Route::get('/lowongan/{id}', [HomeController::class, 'lowonganDetail'])->name('lowongan.detail');
Route::get('/kontak', [HomeController::class, 'kontak'])->name('kontak');

Route::get('/profil', [HomeController::class, 'profil'])->name('profil');

Route::get('/demografi', [HomeController::class, 'demografi'])->name('demografi');

// Checkout routes (temporary)
Route::get('/checkout', function () {
    return view('produk.checkout.checkout');
})->name('checkout');

Route::get('/checkout1', function () {
    return view('produk.checkout.checkout1');
})->name('checkout1');

Route::get('/checkout2', function () {
    return view('produk.checkout.checkout2');
})->name('checkout2');

// Specific product routes (temporary)
Route::get('/dtf', function () {
    return view('produk.dtf');
})->name('dtf');

Route::get('/sepatu', function () {
    return view('produk.sepatu');
})->name('sepatu');

Route::get('/kopi', function () {
    return view('produk.kopi');
})->name('kopi');

Route::get('/tempe', function () {
    return view('produk.tempe');
})->name('tempe');

// Authentication Routes
Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::get('/register', [AuthController::class, 'showRegisterForm'])->name('register');
Route::post('/register', [AuthController::class, 'register']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// Admin Routes
Route::prefix('admin')->middleware(['auth', 'role:superadmin,admin'])->name('admin.')->group(function () {
    // Dashboard
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('dashboard');
    
    // Profile
    Route::get('/profile', [AdminController::class, 'profile'])->name('profile');
    Route::put('/profile', [AdminController::class, 'updateProfile'])->name('profile.update');
    
    // Berita Management
    Route::resource('berita', BeritaController::class)->parameters(['berita' => 'berita']);
    
    // Produk Management
    Route::resource('produk', ProdukController::class);
    
    // Lowongan Management
    Route::resource('lowongan', LowonganController::class);
    
    // Demografi Management
    Route::resource('demografi', DemografiController::class);
    
    // Profil Desa Management
    Route::resource('profil', ProfilDesaController::class);

    // Anggaran Management (Transparansi Anggaran)
    Route::resource('anggaran', AnggaranController::class);

    // Staf Desa Management
    Route::prefix('staf')->name('staf.')->group(function () {
        Route::get('/', [StafDesaController::class, 'index'])->name('index');
        Route::get('/create', [StafDesaController::class, 'create'])->name('create');
        Route::post('/', [StafDesaController::class, 'store'])->name('store');
        Route::get('/{index}/edit', [StafDesaController::class, 'edit'])->name('edit')->whereNumber('index');
        Route::put('/{index}', [StafDesaController::class, 'update'])->name('update')->whereNumber('index');
        Route::delete('/{index}', [StafDesaController::class, 'destroy'])->name('destroy')->whereNumber('index');
    });
});
