﻿
<?php $__env->startSection('title', $profil ? 'Profil ' . $profil->nama_desa : 'Profil Desa'); ?>

<?php $__env->startSection('content'); ?>

<!-- Hero Section -->
<section class="relative bg-green-700 text-white py-20 shadow-lg">
  <div class="max-w-6xl mx-auto px-6 text-center">
    <h1 class="text-4xl md:text-5xl font-extrabold mb-4">
      <?php if($profil && $profil->nama_desa): ?>
        Profil <?php echo e($profil->nama_desa); ?>

      <?php else: ?>
        Profil Desa Baujeng
      <?php endif; ?>
    </h1>
    <p class="text-lg md:text-xl opacity-90">
      <?php if($profil && $profil->nama_desa): ?>
        Mengenal lebih dekat <?php echo e($profil->nama_desa); ?>, sejarah, visi misi, potensi, dan masyarakatnya
      <?php else: ?>
        Mengenal lebih dekat Desa Baujeng, sejarah, visi misi, potensi, dan masyarakatnya
      <?php endif; ?>
    </p>
  </div>
  <div class="absolute bottom-0 left-0 right-0">
    <svg class="w-full h-16 text-white" viewBox="0 0 1440 320" preserveAspectRatio="none" fill="currentColor">
      <path d="M0,160L48,170.7C96,181,192,203,288,218.7C384,235,480,245,576,245.3C672,245,768,235,864,224C960,213,1056,203,1152,181.3C1248,160,1344,128,1392,112L1440,96L1440,320L0,320Z"></path>
    </svg>
  </div>
</section>

<!-- Sejarah -->
<section class="max-w-6xl mx-auto px-6 py-12 grid md:grid-cols-2 gap-10 items-center">
  <div>
    <h2 class="text-3xl font-bold text-green-800 mb-4">Sejarah Desa</h2>
    <p class="text-gray-700 leading-relaxed">
      <?php if($profil && $profil->sejarah): ?>
        <?php echo nl2br(e($profil->sejarah)); ?>

      <?php else: ?>
        Desa Baujeng memiliki sejarah panjang sejak zaman kolonial. Terletak di wilayah yang subur dengan mayoritas penduduk sebagai petani, desa ini tumbuh dengan tradisi gotong royong yang kuat. 
        <span class="font-semibold">Kini Desa Baujeng berkembang menjadi pusat pertanian, UMKM, dan wisata lokal.</span>
      <?php endif; ?>
    </p>
  </div>
  <div class="flex justify-center">
    <?php if($profil && $profil->foto_kantor): ?>
      <img src="<?php echo e(asset('storage/' . $profil->foto_kantor)); ?>" 
           alt="Kantor <?php echo e($profil->nama_desa ?? 'Desa'); ?>" 
           class="rounded-xl shadow-lg hover:scale-105 transition duration-500 max-w-full h-auto object-cover"
           style="max-height: 400px;">
    <?php else: ?>
      <img src="<?php echo e(asset('img/desa.jpg')); ?>" 
           alt="Sejarah Desa" 
           class="rounded-xl shadow-lg hover:scale-105 transition duration-500 max-w-full h-auto object-cover"
           style="max-height: 400px;">
    <?php endif; ?>
  </div>
</section>

<!-- Visi Misi -->
<section class="bg-gray-50 py-12">
  <div class="max-w-6xl mx-auto px-6">
    <h2 class="text-3xl font-bold text-green-800 mb-8 text-center">Visi & Misi</h2>
    <div class="grid md:grid-cols-2 gap-10">
      <div class="bg-white p-6 rounded-xl shadow hover:shadow-xl transition">
        <h3 class="font-bold text-xl text-green-700 mb-3">Visi</h3>
        <p class="text-gray-700">
          <?php if($profil && $profil->visi): ?>
            "<?php echo e($profil->visi); ?>"
          <?php else: ?>
            "Mewujudkan Desa Baujeng yang maju, mandiri, religius, dan berdaya saing dengan tetap menjaga budaya lokal."
          <?php endif; ?>
        </p>
      </div>
      <div class="bg-white p-6 rounded-xl shadow hover:shadow-xl transition">
        <h3 class="font-bold text-xl text-green-700 mb-3">Misi</h3>
        <div class="text-gray-700">
          <?php if($profil && $profil->misi): ?>
            <?php echo nl2br(e($profil->misi)); ?>

          <?php else: ?>
            <ul class="list-disc list-inside space-y-2">
              <li>Meningkatkan kualitas pendidikan dan kesehatan masyarakat.</li>
              <li>Mendorong pertumbuhan ekonomi melalui UMKM & pertanian.</li>
              <li>Menjaga kelestarian lingkungan dan budaya lokal.</li>
              <li>Meningkatkan tata kelola pemerintahan desa yang transparan.</li>
            </ul>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Informasi Desa -->
<?php if($profil && (
    $profil->luas_wilayah || 
    $profil->jumlah_dusun || 
    $profil->jumlah_rw || 
    $profil->jumlah_rt
)): ?>
<section class="bg-blue-50 py-12">
  <div class="max-w-6xl mx-auto px-6">
    <h2 class="text-3xl font-bold text-green-800 mb-8 text-center">Informasi Desa</h2>
    
    <div class="grid sm:grid-cols-2 lg:grid-cols-4 gap-6">
      
      <?php if($profil->luas_wilayah): ?>
      <div class="bg-white p-6 rounded-xl shadow hover:shadow-xl transition text-center">
        <div class="w-16 h-16 bg-green-100 rounded-full mx-auto mb-4 flex items-center justify-center">
          <i class="fas fa-map text-green-600 text-2xl"></i>
        </div>
        <h3 class="font-bold text-xl text-gray-800 mb-2">
          <?php echo e(number_format($profil->luas_wilayah, 2)); ?> km²
        </h3>
        <p class="text-gray-600">Luas Wilayah</p>
      </div>
      <?php endif; ?>

      <?php if($profil->jumlah_dusun): ?>
      <div class="bg-white p-6 rounded-xl shadow hover:shadow-xl transition text-center">
        <div class="w-16 h-16 bg-yellow-100 rounded-full mx-auto mb-4 flex items-center justify-center">
          <i class="fas fa-tree text-yellow-600 text-2xl"></i>
        </div>
        <h3 class="font-bold text-xl text-gray-800 mb-2">
          <?php echo e(number_format($profil->jumlah_dusun)); ?>

        </h3>
        <p class="text-gray-600">Jumlah Dusun</p>
      </div>
      <?php endif; ?>

      <?php if($profil->jumlah_rw): ?>
      <div class="bg-white p-6 rounded-xl shadow hover:shadow-xl transition text-center">
        <div class="w-16 h-16 bg-pink-100 rounded-full mx-auto mb-4 flex items-center justify-center">
          <i class="fas fa-layer-group text-pink-600 text-2xl"></i>
        </div>
        <h3 class="font-bold text-xl text-gray-800 mb-2">
          <?php echo e(number_format($profil->jumlah_rw)); ?>

        </h3>
        <p class="text-gray-600">Jumlah RW</p>
      </div>
      <?php endif; ?>

      <?php if($profil->jumlah_rt): ?>
      <div class="bg-white p-6 rounded-xl shadow hover:shadow-xl transition text-center">
        <div class="w-16 h-16 bg-red-100 rounded-full mx-auto mb-4 flex items-center justify-center">
          <i class="fas fa-users-cog text-red-600 text-2xl"></i>
        </div>
        <h3 class="font-bold text-xl text-gray-800 mb-2">
          <?php echo e(number_format($profil->jumlah_rt)); ?>

        </h3>
        <p class="text-gray-600">Jumlah RT</p>
      </div>
      <?php endif; ?>

    </div>
  </div>
</section>
<?php endif; ?>

<!-- Potensi Desa -->
<section class="max-w-6xl mx-auto px-6 py-12">
  <h2 class="text-3xl font-bold text-green-800 mb-8 text-center">Potensi Desa</h2>
  <div class="grid sm:grid-cols-2 lg:grid-cols-3 gap-8">
    <div class="bg-white shadow rounded-xl p-6 text-center hover:scale-105 transition">
      <img src="<?php echo e(asset('img/slide1.jpeg')); ?>" class="w-full h-40 object-cover rounded-md mb-4" alt="Pertanian">
      <h3 class="font-semibold text-lg text-green-700">Pertanian</h3>
      <p class="text-gray-600 text-sm">Lahan subur menghasilkan padi, jagung, dan sayur-mayur unggulan.</p>
    </div>
    <div class="bg-white shadow rounded-xl p-6 text-center hover:scale-105 transition">
      <img src="<?php echo e(asset('img/Produk/sepatu.jpg')); ?>" class="w-full h-40 object-cover rounded-md mb-4" alt="UMKM">
      <h3 class="font-semibold text-lg text-green-700">UMKM</h3>
      <p class="text-gray-600 text-sm">Beragam usaha mikro seperti kerajinan tangan, kuliner, dan sablon.</p>
    </div>
    <div class="bg-white shadow rounded-xl p-6 text-center hover:scale-105 transition">
      <img src="<?php echo e(asset('img/slide3.webp')); ?>" class="w-full h-40 object-cover rounded-md mb-4" alt="Wisata">
      <h3 class="font-semibold text-lg text-green-700">Wisata Lokal</h3>
      <p class="text-gray-600 text-sm">Destinasi alam dan budaya yang menarik bagi wisatawan lokal maupun luar daerah.</p>
    </div>
  </div>
</section>

<!-- Sambutan Kepala Desa -->
<section class="bg-green-700 py-12 text-white">
  <div class="max-w-6xl mx-auto px-6">
    <h2 class="text-3xl font-bold mb-12 text-center">
      <?php if($profil && $profil->nama_desa && $profil->kecamatan): ?>
        Pemerintah <?php echo e($profil->nama_desa); ?> - Kecamatan <?php echo e($profil->kecamatan); ?>

      <?php else: ?>
        Sambutan Kepala Desa Baujeng - Kecamatan Beji
      <?php endif; ?>
    </h2>

    <div class="grid sm:grid-cols-2 lg:grid-cols-4 gap-8 text-center">

      <!-- Kepala Desa -->
      <?php if($profil && $profil->kepala_desa): ?>
        <div class="bg-white text-gray-800 rounded-xl shadow-lg p-6 hover:scale-105 transition">
          <?php if($profil->foto_kepala_desa): ?>
            <img src="<?php echo e(asset('storage/' . $profil->foto_kepala_desa)); ?>" 
                 class="w-28 h-28 object-cover rounded-full mx-auto mb-4" 
                 alt="Kepala Desa">
          <?php else: ?>
            <div class="w-28 h-28 bg-gray-200 rounded-full mx-auto mb-4 flex items-center justify-center">
              <i class="fas fa-user text-gray-400 text-3xl"></i>
            </div>
          <?php endif; ?>
          <h4 class="font-semibold text-lg"><?php echo e($profil->kepala_desa); ?></h4>
          <p class="text-sm text-gray-600">Kepala Desa</p>
        </div>
      <?php else: ?>
        <div class="bg-white text-gray-800 rounded-xl shadow-lg p-6 hover:scale-105 transition">
          <img src="<?php echo e(asset('img/karangtaruna/ketua.jpg')); ?>" class="w-28 h-28 object-cover rounded-full mx-auto mb-4" alt="Kepala Desa">
          <h4 class="font-semibold text-lg">Andi Prasetyo</h4>
          <p class="text-sm text-gray-600">Kepala Desa</p>
        </div>
      <?php endif; ?>

      <!-- Sekretaris Desa -->
      <?php if($profil && $profil->sekdes): ?>
        <div class="bg-white text-gray-800 rounded-xl shadow-lg p-6 hover:scale-105 transition">
          <?php if($profil->foto_sekdes): ?>
            <img src="<?php echo e(asset('storage/' . $profil->foto_sekdes)); ?>" 
                 class="w-28 h-28 object-cover rounded-full mx-auto mb-4" 
                 alt="Sekretaris Desa">
          <?php else: ?>
            <div class="w-28 h-28 bg-gray-200 rounded-full mx-auto mb-4 flex items-center justify-center">
              <i class="fas fa-user text-gray-400 text-3xl"></i>
            </div>
          <?php endif; ?>
          <h4 class="font-semibold text-lg"><?php echo e($profil->sekdes); ?></h4>
          <p class="text-sm text-gray-600">Sekretaris Desa</p>
        </div>
      <?php else: ?>
        <div class="bg-white text-gray-800 rounded-xl shadow-lg p-6 hover:scale-105 transition">
          <img src="<?php echo e(asset('img/karangtaruna/wakil.jpg')); ?>" class="w-28 h-28 object-cover rounded-full mx-auto mb-4" alt="Sekretaris Desa">
          <h4 class="font-semibold text-lg">Siti Nurhaliza</h4>
          <p class="text-sm text-gray-600">Sekdes</p>
        </div>
      <?php endif; ?>

      <!-- BKD -->
      <?php if($profil && $profil->bkd): ?>
        <div class="bg-white text-gray-800 rounded-xl shadow-lg p-6 hover:scale-105 transition">
          <?php if($profil->foto_bkd): ?>
            <img src="<?php echo e(asset('storage/' . $profil->foto_bkd)); ?>" 
                 class="w-28 h-28 object-cover rounded-full mx-auto mb-4" 
                 alt="BKD">
          <?php else: ?>
            <div class="w-28 h-28 bg-gray-200 rounded-full mx-auto mb-4 flex items-center justify-center">
              <i class="fas fa-user text-gray-400 text-3xl"></i>
            </div>
          <?php endif; ?>
          <h4 class="font-semibold text-lg"><?php echo e($profil->bkd); ?></h4>
          <p class="text-sm text-gray-600">BKD</p>
        </div>
      <?php else: ?>
        <div class="bg-white text-gray-800 rounded-xl shadow-lg p-6 hover:scale-105 transition">
          <img src="<?php echo e(asset('img/karangtaruna/sekretaris.jpg')); ?>" class="w-28 h-28 object-cover rounded-full mx-auto mb-4" alt="BKD">
          <h4 class="font-semibold text-lg">Bambang Setiawan</h4>
          <p class="text-sm text-gray-600">BKD</p>
        </div>
      <?php endif; ?>

      <!-- Bendahara -->
      <?php if($profil && $profil->bendahara): ?>
        <div class="bg-white text-gray-800 rounded-xl shadow-lg p-6 hover:scale-105 transition">
          <?php if($profil->foto_bendahara): ?>
            <img src="<?php echo e(asset('storage/' . $profil->foto_bendahara)); ?>" 
                 class="w-28 h-28 object-cover rounded-full mx-auto mb-4" 
                 alt="Bendahara">
          <?php else: ?>
            <div class="w-28 h-28 bg-gray-200 rounded-full mx-auto mb-4 flex items-center justify-center">
              <i class="fas fa-user text-gray-400 text-3xl"></i>
            </div>
          <?php endif; ?>
          <h4 class="font-semibold text-lg"><?php echo e($profil->bendahara); ?></h4>
          <p class="text-sm text-gray-600">Bendahara</p>
        </div>
      <?php else: ?>
        <div class="bg-white text-gray-800 rounded-xl shadow-lg p-6 hover:scale-105 transition">
          <img src="<?php echo e(asset('img/karangtaruna/bendahara.jpg')); ?>" class="w-28 h-28 object-cover rounded-full mx-auto mb-4" alt="Bendahara">
          <h4 class="font-semibold text-lg">Rina Anggraini</h4>
          <p class="text-sm text-gray-600">Bendahara</p>
        </div>
      <?php endif; ?>

    </div>
  </div>
</section>

<!-- Kontak Desa -->
<?php if($profil && ($profil->alamat || $profil->telepon || $profil->email || $profil->website)): ?>
<section class="relative bg-gradient-to-r from-green-50 via-white to-green-50 py-20">
  <div class="max-w-7xl mx-auto px-6 relative z-10">
    <!-- Heading -->
    <div class="text-center mb-16">
      <h2 class="text-4xl md:text-5xl font-extrabold text-green-700 mb-4">Kontak Desa</h2>
      <div class="w-24 h-1 bg-green-500 mx-auto rounded"></div>
      <p class="mt-4 text-gray-600 max-w-2xl mx-auto">
        Silakan hubungi kami melalui informasi berikut untuk layanan maupun pertanyaan seputar Desa.
      </p>
    </div>

    <!-- Cards -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8">
      
      
      <?php if($profil->alamat): ?>
      <div class="bg-white/70 backdrop-blur-lg p-8 rounded-2xl shadow-lg hover:shadow-2xl transition transform hover:-translate-y-2 text-center">
        <div class="w-16 h-16 bg-gradient-to-tr from-white to-gray-200 rounded-full mx-auto mb-6 flex item-center justify-center shadow-md">
          <img src="<?php echo e(asset('img/gambar/map.png')); ?>" alt="Alamat" class="w-8 h-8 object-contain">
        </div>
        <h4 class="font-bold text-lg text-gray-800 mb-3">Alamat</h4>
        <p class="text-gray-700 text-sm leading-relaxed"><?php echo e($profil->alamat); ?></p>
        <?php if($profil->kecamatan && $profil->kabupaten): ?>
          <p class="text-gray-700 text-sm"><?php echo e($profil->kecamatan); ?>, <?php echo e($profil->kabupaten); ?></p>
        <?php endif; ?>
        <?php if($profil->provinsi): ?>
          <p class="text-gray-700 text-sm"><?php echo e($profil->provinsi); ?></p>
        <?php endif; ?>
        <?php if($profil->kode_pos): ?>
          <p class="text-gray-700 text-sm">Kode Pos: <?php echo e($profil->kode_pos); ?></p>
        <?php endif; ?>
      </div>
      <?php endif; ?>

      
      <?php if($profil->telepon): ?>
      <div class="bg-white/70 backdrop-blur-lg p-8 rounded-2xl shadow-lg hover:shadow-2xl transition transform hover:-translate-y-2 text-center">
        <div class="w-16 h-16 bg-gradient-to-tr from-white to-gray-200 rounded-full mx-auto mb-6 flex item-center justify-center shadow-md">
          <img src="<?php echo e(asset('img/gambar/app.png')); ?>" alt="Alamat" class="w-8 h-8 object-contain">
        </div>
        <h4 class="font-bold text-lg text-gray-800 mb-3">Telepon</h4>
        <p class="text-gray-700 text-sm"><?php echo e($profil->telepon); ?></p>
      </div>
      <?php endif; ?>

      
      <?php if($profil->email): ?>
      <div class="bg-white/70 backdrop-blur-lg p-8 rounded-2xl shadow-lg hover:shadow-2xl transition transform hover:-translate-y-2 text-center">
        <div class="w-16 h-16 bg-gradient-to-tr from-white to-gray-200 rounded-full mx-auto mb-6 flex item-center justify-center shadow-md">
          <img src="<?php echo e(asset('img/gambar/communication.png')); ?>" alt="Alamat" class="w-8 h-8 object-contain">
        </div>
        <h4 class="font-bold text-lg text-gray-800 mb-3">Email</h4>
        <a href="mailto:<?php echo e($profil->email); ?>" class="text-blue-600 text-sm hover:underline">
          <?php echo e($profil->email); ?>

        </a>
      </div>
      <?php endif; ?>

      
      <?php if($profil->website): ?>
      <div class="bg-white/70 backdrop-blur-lg p-8 rounded-2xl shadow-lg hover:shadow-2xl transition transform hover:-translate-y-2 text-center">
        <div class="w-16 h-16 bg-gradient-to-tr from-white to-gray-200 rounded-full mx-auto mb-6 flex item-center justify-center shadow-md">
          <img src="<?php echo e(asset('img/gambar/web-link.png')); ?>" alt="Alamat" class="w-8 h-8 object-contain">
        </div>
        <h4 class="font-bold text-lg text-gray-800 mb-3">Website</h4>
        <a href="<?php echo e($profil->website); ?>" target="_blank" class="text-purple-600 text-sm hover:underline">
          <?php echo e($profil->website); ?>

        </a>
      </div>
      <?php endif; ?>

    </div>

    <!-- Optional Google Maps -->
    <?php if($profil->alamat): ?>
    <div class="mt-16 rounded-2xl overflow-hidden shadow-lg">
      <iframe 
        src="https://www.google.com/maps?q=<?php echo e(urlencode($profil->alamat)); ?>&output=embed" 
        width="100%" 
        height="400" 
        style="border:0;" 
        allowfullscreen="" 
        loading="lazy">
      </iframe>
    </div>
    <?php endif; ?>

  </div>
</section>
<?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\webdesa\resources\views/profil.blade.php ENDPATH**/ ?>