<?php $__env->startSection('title', 'Manajemen Berita'); ?>
<?php $__env->startSection('page-icon', '<i class="fas fa-newspaper text-info me-2"></i>'); ?>
<?php $__env->startSection('page-title', 'Manajemen Berita'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-newspaper"></i> Daftar Berita</h5>
                <a href="<?php echo e(route('admin.berita.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Tambah Berita
                </a>
            </div>
            <div class="card-body">
                <?php if($berita->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th width="5%">#</th>
                                    <th width="15%">Gambar</th>
                                    <th width="30%">Judul</th>
                                    <th width="15%">Kategori</th>
                                    <th width="10%">Status</th>
                                    <th width="10%">Tanggal</th>
                                    <th width="15%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $berita; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($berita->firstItem() + $index); ?></td>
                                        <td>
                                            <?php if($item->gambar): ?>
                                                <img src="<?php echo e(asset('storage/' . $item->gambar)); ?>" 
                                                     alt="<?php echo e($item->judul); ?>" 
                                                     class="img-thumbnail" 
                                                     style="width: 60px; height: 60px; object-fit: cover;">
                                            <?php else: ?>
                                                <div class="bg-light d-flex align-items-center justify-content-center" 
                                                     style="width: 60px; height: 60px;">
                                                    <i class="fas fa-image text-muted"></i>
                                                </div>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <h6 class="mb-1"><?php echo e(Str::limit($item->judul, 50)); ?></h6>
                                            <small class="text-muted"><?php echo e(Str::limit($item->excerpt, 80)); ?></small>
                                        </td>
                                        <td>
                                            <span class="badge bg-secondary"><?php echo e($item->kategori); ?></span>
                                        </td>
                                        <td>
                                            <span class="badge bg-<?php echo e($item->status == 'published' ? 'success' : 'warning'); ?>">
                                                <?php echo e(ucfirst($item->status)); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <small><?php echo e($item->created_at->format('d M Y')); ?></small>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="<?php echo e(route('admin.berita.show', $item)); ?>" 
                                                   class="btn btn-sm btn-info" title="Lihat">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="<?php echo e(route('admin.berita.edit', $item)); ?>" 
                                                   class="btn btn-sm btn-warning" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="<?php echo e(route('admin.berita.destroy', $item)); ?>" 
                                                      method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-sm btn-danger" 
                                                            title="Hapus"
                                                            onclick="return confirm('Yakin ingin menghapus berita ini?')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="d-flex justify-content-center">
                        <?php echo e($berita->links()); ?>

                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="fas fa-newspaper fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">Belum ada berita</h5>
                        <p class="text-muted">Mulai dengan menambahkan berita pertama Anda</p>
                        <a href="<?php echo e(route('admin.berita.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Tambah Berita
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\webdesa\resources\views/admin/berita/index.blade.php ENDPATH**/ ?>