<?php $__env->startSection('title', 'Manajemen Demografi'); ?>
<?php $__env->startSection('page-title', 'Manajemen Data Demografi'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-chart-pie"></i> Data Demografi Desa</h5>
                <a href="<?php echo e(route('admin.demografi.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Tambah Data
                </a>
            </div>
            <div class="card-body">
                <?php if($demografi->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th width="5%">#</th>
                                    <th width="25%">Kategori</th>
                                    <th width="20%">Label</th>
                                    <th width="15%">Jumlah</th>
                                    <th width="20%">Keterangan</th>
                                    <th width="10%">Tahun</th>
                                    <th width="5%">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $demografi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($demografi->firstItem() + $index); ?></td>
                                        <td>
                                            <span class="badge bg-primary"><?php echo e($item->kategori); ?></span>
                                        </td>
                                        <td>
                                            <strong><?php echo e($item->label); ?></strong>
                                        </td>
                                        <td>
                                            <h6 class="mb-0 text-success"><?php echo e(number_format($item->jumlah, 0, ',', '.')); ?></h6>
                                        </td>
                                        <td>
                                            <small class="text-muted"><?php echo e(Str::limit($item->keterangan ?? 'Tidak ada keterangan', 40)); ?></small>
                                        </td>
                                        <td>
                                            <span class="badge bg-info"><?php echo e($item->tahun ?? '-'); ?></span>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="<?php echo e(route('admin.demografi.show', $item->id)); ?>" 
                                                   class="btn btn-sm btn-info" title="Lihat">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="<?php echo e(route('admin.demografi.edit', $item->id)); ?>" 
                                                   class="btn btn-sm btn-warning" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="<?php echo e(route('admin.demografi.destroy', $item->id)); ?>" 
                                                      method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-sm btn-danger" 
                                                            title="Hapus"
                                                            onclick="return confirm('Yakin ingin menghapus data ini?')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="d-flex justify-content-center">
                        <?php echo e($demografi->links()); ?>

                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="fas fa-chart-pie fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">Belum ada data demografi</h5>
                        <p class="text-muted">Mulai dengan menambahkan data demografi desa</p>
                        <a href="<?php echo e(route('admin.demografi.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Tambah Data
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Quick Stats by Category -->
<div class="row mt-4">
    <?php
        $categories = \App\Models\Demografi::select('kategori')
            ->selectRaw('COUNT(*) as total')
            ->selectRaw('SUM(jumlah) as total_jumlah')
            ->groupBy('kategori')
            ->get();
        
        $categoryColors = [
            'Jenis Kelamin' => 'primary',
            'Kelompok Usia' => 'success', 
            'Pendidikan' => 'info',
            'Pekerjaan' => 'warning',
            'Agama' => 'secondary',
            'Lainnya' => 'dark'
        ];
    ?>
    
    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-4 mb-3">
            <div class="card bg-<?php echo e($categoryColors[$category->kategori] ?? 'primary'); ?> text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h4><?php echo e($category->total); ?></h4>
                            <p class="mb-0"><?php echo e(ucfirst($category->kategori)); ?></p>
                            <small>Total: <?php echo e(number_format($category->total_jumlah, 0, ',', '.')); ?></small>
                        </div>
                        <i class="fas fa-<?php echo e($category->kategori == 'Jenis Kelamin' ? 'venus-mars' : ($category->kategori == 'Kelompok Usia' ? 'user-clock' : ($category->kategori == 'Pendidikan' ? 'graduation-cap' : ($category->kategori == 'Pekerjaan' ? 'briefcase' : ($category->kategori == 'Agama' ? 'place-of-worship' : 'chart-bar'))))); ?> fa-2x opacity-75"></i>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<!-- Data Summary -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h6 class="mb-0"><i class="fas fa-chart-bar"></i> Ringkasan Data Demografi</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6 mb-3">
                            <h6><?php echo e($category->kategori); ?></h6>
                            <?php
                                $categoryData = \App\Models\Demografi::where('kategori', $category->kategori)
                                    ->orderBy('jumlah', 'desc')
                                    ->limit(3)
                                    ->get();
                            ?>
                            
                            <?php $__currentLoopData = $categoryData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <span><?php echo e($data->label); ?></span>
                                    <span class="badge bg-<?php echo e($categoryColors[$category->kategori] ?? 'primary'); ?>">
                                        <?php echo e(number_format($data->jumlah, 0, ',', '.')); ?>

                                    </span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\webdesa\resources\views/admin/demografi/index.blade.php ENDPATH**/ ?>