<?php $__env->startSection('title', $berita->judul . ' - Berita Desa Baujeng'); ?>

<?php $__env->startSection('content'); ?>

<!-- Breadcrumb -->
<nav class="bg-gray-50 py-4">
  <div class="max-w-7xl mx-auto px-6">
    <ol class="flex items-center space-x-2 text-sm">
      <li><a href="<?php echo e(route('home')); ?>" class="text-blue-600 hover:text-blue-800">Beranda</a></li>
      <li class="text-gray-500">/</li>
      <li><a href="<?php echo e(route('berita')); ?>" class="text-blue-600 hover:text-blue-800">Berita</a></li>
      <li class="text-gray-500">/</li>
      <li class="text-gray-700 font-medium"><?php echo e(Str::limit($berita->judul, 50)); ?></li>
    </ol>
  </div>
</nav>

<!-- Article Content -->
<article class="max-w-4xl mx-auto px-6 py-12">
  <!-- Article Header -->
  <header class="mb-8">
    <div class="flex items-center text-sm text-gray-500 mb-4">
      <span class="bg-blue-100 text-blue-700 px-3 py-1 rounded-full text-xs font-medium">
        <?php echo e($berita->kategori ?? 'Umum'); ?>

      </span>
      <span class="mx-3">•</span>
      <time datetime="<?php echo e($berita->published_at ? $berita->published_at->format('Y-m-d') : $berita->created_at->format('Y-m-d')); ?>">
        <?php echo e($berita->published_at ? $berita->published_at->format('d F Y') : $berita->created_at->format('d F Y')); ?>

      </time>
      <span class="mx-3">•</span>
      <span>Oleh: <?php echo e($berita->penulis ?? 'Admin'); ?></span>
    </div>
    
    <h1 class="text-3xl md:text-4xl font-bold text-gray-900 leading-tight mb-6">
      <?php echo e($berita->judul); ?>

    </h1>
    
    <?php if($berita->gambar): ?>
    <div class="aspect-video overflow-hidden rounded-2xl mb-6">
      <img src="<?php echo e(asset('storage/' . $berita->gambar)); ?>" 
           alt="<?php echo e($berita->judul); ?>" 
           class="w-full h-full object-cover">
    </div>
    <?php endif; ?>
  </header>

  <!-- Article Body -->
  <div class="prose prose-lg max-w-none">
    <?php echo $berita->konten; ?>

  </div>

  <!-- Article Footer -->
  <footer class="mt-12 pt-8 border-t border-gray-200">
    <div class="flex items-center justify-between">
      <div class="text-sm text-gray-500">
        <p>Dipublikasikan: <?php echo e($berita->published_at ? $berita->published_at->format('d F Y, H:i') : $berita->created_at->format('d F Y, H:i')); ?></p>
        <?php if($berita->updated_at != $berita->created_at): ?>
        <p>Diperbarui: <?php echo e($berita->updated_at->format('d F Y, H:i')); ?></p>
        <?php endif; ?>
      </div>
      
      <a href="<?php echo e(route('berita')); ?>" 
         class="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
        </svg>
        Kembali ke Berita
      </a>
    </div>
  </footer>
</article>

<!-- Related Articles -->
<?php if($relatedBerita->count() > 0): ?>
<section class="bg-gray-50 py-16">
  <div class="max-w-7xl mx-auto px-6">
    <h2 class="text-2xl md:text-3xl font-bold text-gray-800 mb-8 text-center">Berita Terkait</h2>
    
    <div class="grid md:grid-cols-3 gap-8">
      <?php $__currentLoopData = $relatedBerita; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <article class="bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-shadow">
        <?php if($item->gambar): ?>
        <div class="aspect-video overflow-hidden">
          <img src="<?php echo e(asset('storage/' . $item->gambar)); ?>" 
               alt="<?php echo e($item->judul); ?>" 
               class="w-full h-full object-cover hover:scale-105 transition-transform duration-300">
        </div>
        <?php else: ?>
        <div class="aspect-video bg-gradient-to-br from-blue-500 to-blue-700 flex items-center justify-center">
          <span class="text-white text-3xl">📰</span>
        </div>
        <?php endif; ?>
        
        <div class="p-6">
          <div class="text-sm text-gray-500 mb-2">
            <?php echo e($item->published_at ? $item->published_at->format('d M Y') : $item->created_at->format('d M Y')); ?>

          </div>
          
          <h3 class="text-lg font-bold text-gray-800 mb-3 line-clamp-2">
            <a href="<?php echo e(route('berita.detail', $item->slug)); ?>" class="hover:text-blue-600 transition-colors">
              <?php echo e($item->judul); ?>

            </a>
          </h3>
          
          <p class="text-gray-600 text-sm line-clamp-3">
            <?php echo e(Str::limit(strip_tags($item->konten), 100)); ?>

          </p>
        </div>
      </article>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
  </div>
</section>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.prose {
  color: #374151;
  line-height: 1.75;
}

.prose p {
  margin-bottom: 1.25rem;
}

.prose h2 {
  font-size: 1.5rem;
  font-weight: 700;
  margin-top: 2rem;
  margin-bottom: 1rem;
  color: #1f2937;
}

.prose h3 {
  font-size: 1.25rem;
  font-weight: 600;
  margin-top: 1.5rem;
  margin-bottom: 0.75rem;
  color: #1f2937;
}

.prose ul, .prose ol {
  margin-bottom: 1.25rem;
  padding-left: 1.5rem;
}

.prose li {
  margin-bottom: 0.5rem;
}

.line-clamp-2 {
  display: -webkit-box;
  -webkit-line-clamp: 2;
  -webkit-box-orient: vertical;
  overflow: hidden;
}

.line-clamp-3 {
  display: -webkit-box;
  -webkit-line-clamp: 3;
  -webkit-box-orient: vertical;
  overflow: hidden;
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\webdesa\resources\views/berita/detail.blade.php ENDPATH**/ ?>