﻿

<?php $__env->startSection('title', 'Transparansi Anggaran'); ?>
<?php $__env->startSection('page-title', 'Transparansi Anggaran / Anggaran Desa'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
  <div class="col-12">
    <div class="card">
      <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">
          <i class="fas fa-money-bill-wave"></i> Daftar Anggaran
        </h5>
        <a href="<?php echo e(route('admin.anggaran.create')); ?>" class="btn btn-primary">
          <i class="fas fa-plus"></i> Tambah Anggaran
        </a>
      </div>

      <div class="card-body">
        <?php if(session('success')): ?>
          <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>

        <div class="table-responsive">
          <table class="table table-hover align-middle">
            <thead class="table-light">
              <tr>
                <th width="5%">#</th>
                <th width="25%">Kategori</th>
                <th width="20%">Jumlah</th>
                <th>Keterangan</th>
                <th width="20%">Aksi</th>
              </tr>
            </thead>

            <tbody>
              <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                  <td><?php echo e($i + 1); ?></td>
                  <td><?php echo e($item->kategori); ?></td>
                  <td>
                    <strong class="text-success">
                      Rp <?php echo e(number_format($item->jumlah, 0, ',', '.')); ?>

                    </strong>
                  </td>
                  <td><?php echo e($item->keterangan); ?></td>
                  <td>
                    <div class="d-flex gap-2">
                      <a href="<?php echo e(route('admin.anggaran.edit', $item)); ?>" class="btn btn-sm btn-warning">
                        <i class="fas fa-edit"></i> Edit
                      </a>
                      <form action="<?php echo e(route('admin.anggaran.destroy', $item)); ?>" method="POST" onsubmit="return confirm('Hapus anggaran ini?')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button class="btn btn-sm btn-danger">
                          <i class="fas fa-trash-alt"></i> Hapus
                        </button>
                      </form>
                    </div>
                  </td>
                </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                  <td colspan="5" class="text-center text-muted">
                    Belum ada data anggaran
                  </td>
                </tr>
              <?php endif; ?>
            </tbody>

            <tfoot class="table-light">
              <tr>
                <td colspan="2"><strong>Total</strong></td>
                <td colspan="3">
                  <strong class="text-primary">
                    Rp <?php echo e(number_format($total, 0, ',', '.')); ?>

                  </strong>
                </td>
              </tr>
            </tfoot>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\webdesa\resources\views/admin/anggaran/index.blade.php ENDPATH**/ ?>