<?php $__env->startSection('title', 'Berita Desa Baujeng'); ?>

<?php $__env->startSection('main_class', 'flex-1 w-full px-0'); ?>

<?php $__env->startSection('content'); ?>

<!-- Hero Section -->
<section class="relative bg-green-700 text-white py-14 sm:py-20 shadow-xl">
  <div class="max-w-6xl mx-auto px-6 text-center">
    <h1 class="text-3xl sm:text-4xl md:text-5xl font-extrabold mb-4">Berita Desa Baujeng</h1>
    <p class="text-base sm:text-lg md:text-xl opacity-90 max-w-2xl mx-auto">
      Informasi terkini seputar kegiatan dan perkembangan Desa Baujeng
    </p>
  </div>
  <div class="absolute bottom-0 left-0 right-0">
    <svg class="w-full h-12 sm:h-16 text-white" viewBox="0 0 1440 320" preserveAspectRatio="none" fill="currentColor">
      <path d="M0,160L48,170.7C96,181,192,203,288,218.7C384,235,480,245,576,245.3C672,245,768,235,864,224C960,213,1056,203,1152,181.3C1248,160,1344,128,1392,112L1440,96L1440,320L0,320Z"></path>
    </svg>
  </div>
</section>

<!-- Berita List -->
<section class="max-w-7xl mx-auto px-6 py-16">
  <?php if($berita->count() > 0): ?>
    <div class="grid grid-cols-2 md:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-8">
      <?php $__currentLoopData = $berita; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <article class="bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2">
        <?php if($item->gambar): ?>
        <div class="aspect-video overflow-hidden">
          <img src="<?php echo e(asset('storage/' . $item->gambar)); ?>" 
               alt="<?php echo e($item->judul); ?>" 
               class="w-full h-full object-cover hover:scale-105 transition-transform duration-300">
        </div>
        <?php else: ?>
        <div class="aspect-video bg-gradient-to-br from-blue-500 to-blue-700 flex items-center justify-center">
          <span class="text-white text-4xl">📰</span>
        </div>
        <?php endif; ?>
        
        <div class="p-4 sm:p-6">
          <div class="flex items-center text-xs sm:text-sm text-gray-500 mb-3">
            <span class="bg-blue-100 text-blue-700 px-3 py-1 rounded-full text-xs font-medium">
              <?php echo e($item->kategori ?? 'Umum'); ?>

            </span>
            <span class="ml-auto">
              <?php echo e($item->published_at ? $item->published_at->format('d M Y') : $item->created_at->format('d M Y')); ?>

            </span>
          </div>
          
          <h3 class="text-lg sm:text-xl font-bold text-gray-800 mb-3 line-clamp-2">
            <a href="<?php echo e(route('berita.detail', $item->slug)); ?>" class="hover:text-blue-600 transition-colors">
              <?php echo e($item->judul); ?>

            </a>
          </h3>
          
          <p class="text-gray-600 mb-4 line-clamp-3">
            <?php echo e(Str::limit(strip_tags($item->konten), 120)); ?>

          </p>
          
          <div class="flex items-center justify-between">
            <span class="text-xs sm:text-sm text-gray-500">
              Oleh: <?php echo e($item->penulis ?? 'Admin'); ?>

            </span>
            <a href="<?php echo e(route('berita.detail', $item->slug)); ?>" 
               class="inline-flex items-center text-blue-600 hover:text-blue-800 font-medium transition-colors text-xs sm:text-sm">
              Baca Selengkapnya
              <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
              </svg>
            </a>
          </div>
        </div>
      </article>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Pagination -->
    <div class="mt-12">
      <?php echo e($berita->links()); ?>

    </div>
  <?php else: ?>
    <!-- Empty State -->
    <div class="text-center py-16">
      <div class="w-32 h-32 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-6">
        <span class="text-4xl text-gray-400">📰</span>
      </div>
      <h3 class="text-2xl font-bold text-gray-800 mb-4">Belum Ada Berita</h3>
      <p class="text-gray-600 max-w-md mx-auto">
        Saat ini belum ada berita yang dipublikasikan. Silakan kembali lagi nanti untuk mendapatkan informasi terbaru.
      </p>
    </div>
  <?php endif; ?>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.line-clamp-2 {
  display: -webkit-box;
  -webkit-line-clamp: 2;
  -webkit-box-orient: vertical;
  overflow: hidden;
}

.line-clamp-3 {
  display: -webkit-box;
  -webkit-line-clamp: 3;
  -webkit-box-orient: vertical;
  overflow: hidden;
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\webdesa\resources\views/berita/index.blade.php ENDPATH**/ ?>