<?php $__env->startSection('title', 'Produk UMKM Desa Baujeng'); ?>

<?php $__env->startSection('main_class', 'flex-1 w-full px-0'); ?>

<?php $__env->startSection('content'); ?>

<!-- Hero Section -->
<section class="relative bg-green-700 text-white py-14 sm:py-20 shadow-xl">
  <div class="max-w-6xl mx-auto px-6 text-center">
    <h1 class="text-3xl sm:text-4xl md:text-5xl font-extrabold mb-4">Produk UMKM Desa Baujeng</h1>
    <p class="text-base sm:text-lg md:text-xl opacity-90 max-w-2xl mx-auto">
      Temukan berbagai produk unggulan dari UMKM lokal Desa Baujeng yang berkualitas dan terpercaya
    </p>
  </div>
  <div class="absolute bottom-0 left-0 right-0">
    <svg class="w-full h-12 sm:h-16 text-white" viewBox="0 0 1440 320" preserveAspectRatio="none" fill="currentColor">
      <path d="M0,160L48,170.7C96,181,192,203,288,218.7C384,235,480,245,576,245.3C672,245,768,235,864,224C960,213,1056,203,1152,181.3C1248,160,1344,128,1392,112L1440,96L1440,320L0,320Z"></path>
    </svg>
  </div>
</section>

<!-- Filter Section -->
<?php if($kategori->count() > 0): ?>
<section class="bg-gray-50 py-8">
  <div class="max-w-7xl mx-auto px-6">
    <div class="flex flex-wrap items-center justify-center gap-4">
      <span class="text-gray-700 font-medium">Filter Kategori:</span>
      <a href="<?php echo e(route('produk')); ?>" 
         class="px-4 py-2 rounded-full border border-purple-200 text-purple-700 hover:bg-purple-100 transition-colors <?php echo e(!request('kategori') ? 'bg-purple-100' : 'bg-white'); ?>">
        Semua
      </a>
      <?php $__currentLoopData = $kategori; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <a href="<?php echo e(route('produk', ['kategori' => $kat])); ?>" 
         class="px-4 py-2 rounded-full border border-purple-200 text-purple-700 hover:bg-purple-100 transition-colors <?php echo e(request('kategori') == $kat ? 'bg-purple-100' : 'bg-white'); ?>">
        <?php echo e($kat); ?>

      </a>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
  </div>
</section>
<?php endif; ?>

<!-- Products Grid -->
<section class="max-w-7xl mx-auto px-6 py-16">
  <?php if($produk->count() > 0): ?>
    <div class="grid grid-cols-2 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4 sm:gap-8">
      <?php $__currentLoopData = $produk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2">
        <?php
          $img = is_array($item->gambar) ? ($item->gambar[0] ?? null) : $item->gambar;
        ?>
        <?php if($img): ?>
        <div class="aspect-square overflow-hidden">
          <img src="<?php echo e(asset('storage/' . $img)); ?>" 
               alt="<?php echo e($item->nama); ?>" 
               class="w-full h-full object-cover hover:scale-105 transition-transform duration-300">
        </div>
        <?php else: ?>
        <div class="aspect-square bg-gradient-to-br from-green-500 to-green-700 flex items-center justify-center">
          <span class="text-white text-4xl">🛍️</span>
        </div>
        <?php endif; ?>
        
        <div class="p-4 sm:p-6">
          <div class="flex items-center justify-between mb-3">
            <span class="bg-green-100 text-green-700 px-3 py-1 rounded-full text-xs font-medium">
              <?php echo e($item->kategori); ?>

            </span>
            <?php if($item->stok > 0): ?>
            <span class="bg-green-100 text-green-700 px-2 py-1 rounded text-xs font-medium">
              Tersedia
            </span>
            <?php else: ?>
            <span class="bg-red-100 text-red-700 px-2 py-1 rounded text-xs font-medium">
              Habis
            </span>
            <?php endif; ?>
          </div>
          
          <h3 class="text-lg font-bold text-gray-800 mb-2 line-clamp-2">
            <a href="<?php echo e(route('produk.detail', $item->slug)); ?>" class="hover:text-purple-600 transition-colors">
              <?php echo e($item->nama); ?>

            </a>
          </h3>
          
          <p class="text-gray-600 text-sm mb-4 line-clamp-2">
            <?php echo e(Str::limit(strip_tags($item->deskripsi), 80)); ?>

          </p>
          
          <div class="flex items-start sm:items-center justify-between gap-2">
            <div>
              <span class="text-xl sm:text-2xl font-semibold sm:font-bold text-green-600 leading-tight">
                Rp <?php echo e(number_format($item->harga, 0, ',', '.')); ?>

              </span>
              <?php if($item->stok > 0): ?>
              <p class="text-xs text-gray-500">Stok: <?php echo e($item->stok); ?></p>
              <?php endif; ?>
            </div>
            
            <a href="<?php echo e(route('produk.detail', $item->slug)); ?>" 
               class="inline-flex items-center px-3 py-2 sm:px-4 sm:py-2 bg-green-600 text-white rounded-lg hover:bg-purple-700 transition-colors text-xs sm:text-sm">
              Detail
              <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
              </svg>
            </a>
          </div>
        </div>
      </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <!-- Pagination -->
    <div class="mt-12">
      <?php echo e($produk->links()); ?>

    </div>
  <?php else: ?>
    <!-- Empty State -->
    <div class="text-center py-16">
      <div class="w-32 h-32 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-6">
        <span class="text-4xl text-gray-400">🛍️</span>
      </div>
      <h3 class="text-2xl font-bold text-gray-800 mb-4">Belum Ada Produk</h3>
      <p class="text-gray-600 max-w-md mx-auto">
        Saat ini belum ada produk yang tersedia. Silakan kembali lagi nanti untuk melihat produk-produk terbaru dari UMKM lokal.
      </p>
    </div>
  <?php endif; ?>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.line-clamp-2 {
  display: -webkit-box;
  -webkit-line-clamp: 2;
  -webkit-box-orient: vertical;
  overflow: hidden;
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\webdesa\resources\views/produk/index.blade.php ENDPATH**/ ?>