

<?php $__env->startSection('title', 'Data Demografi'); ?>

<?php $__env->startSection('main_class', 'flex-1 w-full px-0'); ?>

<?php $__env->startSection('content'); ?>

<!-- Hero Section --> 
    <section class="relative bg-green-700 text-white py-12 sm:py-20 shadow-lg">
      <div class="max-w-6xl mx-auto px-6 text-center"> 
        <h1 class="text-3xl sm:text-4xl md:text-5xl font-extrabold mb-4">Demografi Desa Baujeng</h1> 
        <p class="text-base sm:text-lg md:text-xl opacity-90"> Data kependudukan Desa Baujeng Kecamatan Beji yang ditampilkan dalam bentuk angka dan grafik interaktif. Semua data sudah dirangkum agar mudah dipahami oleh masyarakat. </p>
      </div>
      <div class="absolute bottom-0 left-0 right-0">
        <svg class="w-full h-10 sm:h-16 text-white" viewBox="0 0 1440 320" preserveAspectRatio="none" fill="currentColor">
          <path d="M0,160L48,170.7C96,181,192,203,288,218.7C384,235,480,245,576,245.3C672,245,768,235,864,224C960,213,1056,203,1152,181.3C1248,160,1344,128,1392,112L1440,96L1440,320L0,320Z"></path>
        </svg>
      </div>
    </section>

<div class="max-w-7xl mx-auto px-4 py-8 sm:py-10">
    
    <div class="bg-white shadow rounded-xl p-4 sm:p-6 flex flex-col md:flex-row justify-center items-center gap-4 sm:gap-6 mb-8 sm:mb-10">
        <div>
            <label for="tahun" class="text-center block text-sm font-semibold text-gray-700">Tahun</label>
            <select id="tahun" class="text-center mt-1 p-2 border rounded-lg focus:ring-2 focus:ring-green-500">
                <option value="2024">2024</option>
                <option value="2025" selected>2025</option>
            </select>
        </div>

        <div>
            <label for="dusun" class="text-center block text-sm font-semibold text-gray-700">Dusun</label>
            <select id="dusun" class="mt-1 p-2 border rounded-lg focus:ring-2 focus:ring-green-500">
                <option value="semua" selected>Semua</option>
                <option value="baujeng">Baujeng</option>
                <option value="nyangking">Nyangking</option>
                <option value="pohkecik">Pohkecik</option>
                <option value="tanggul">Tanggul</option>
                <option value="jambe">Jambe</option>
                <option value="pekeyongan">Pekeyongan</option>
            </select>
        </div>
    </div>

    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 sm:gap-8">
        
        
        <div class="bg-white shadow-lg rounded-2xl p-4 sm:p-6 hover:shadow-2xl transition duration-500">
            <h2 class="text-base sm:text-lg font-bold mb-3 sm:mb-4 text-center text-gray-800">Distribusi Jenis Kelamin</h2>
            <div class="relative h-64 sm:h-80">
                <canvas id="genderChart"></canvas>
            </div>
        </div>
        
        
        <div class="bg-white shadow-lg rounded-2xl p-4 sm:p-6 hover:shadow-2xl transition duration-500">
            <h2 class="text-base sm:text-lg font-bold mb-3 sm:mb-4 text-center text-gray-800">Distribusi Kelompok Usia</h2>
            <div class="relative h-64 sm:h-80">
                <canvas id="ageChart"></canvas>
            </div>
        </div>
        
        
        <div class="bg-white shadow-lg rounded-2xl p-4 sm:p-6 hover:shadow-2xl transition duration-500">
            <h2 class="text-base sm:text-lg font-bold mb-3 sm:mb-4 text-center text-gray-800">Tingkat Pendidikan</h2>
            <div class="relative h-64 sm:h-80">
                <canvas id="educationChart"></canvas>
            </div>
        </div>
        
        
        <div class="bg-white shadow-lg rounded-2xl p-4 sm:p-6 hover:shadow-2xl transition duration-500">
            <h2 class="text-base sm:text-lg font-bold mb-3 sm:mb-4 text-center text-gray-800">Jenis Pekerjaan</h2>
            <div class="relative h-64 sm:h-80">
                <canvas id="jobChart"></canvas>
            </div>
        </div>
        
        <?php if($demografiAgama->count() > 0): ?>
        
        <div class="bg-white shadow-lg rounded-2xl p-4 sm:p-6 hover:shadow-2xl transition duration-500">
            <h2 class="text-base sm:text-lg font-bold mb-3 sm:mb-4 text-center text-gray-800">Distribusi Agama</h2>
            <div class="relative h-64 sm:h-80">
                <canvas id="religionChart"></canvas>
            </div>
        </div>
        <?php endif; ?>
    </div>



</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Chart colors
    const colors = {
        primary: ['#3B82F6', '#EF4444', '#10B981', '#F59E0B', '#8B5CF6', '#F97316', '#06B6D4', '#84CC16'],
        green: '#10B981',
        greenDark: '#059669'
    };
    
    // Chart Jenis Kelamin
    const genderData = <?php echo json_encode($demografiJenisKelamin, 15, 512) ?>;
    if (genderData.length > 0) {
        const genderCtx = document.getElementById('genderChart').getContext('2d');
        new Chart(genderCtx, {
            type: 'doughnut',
            data: {
                labels: genderData.map(item => item.label),
                datasets: [{
                    data: genderData.map(item => item.jumlah),
                    backgroundColor: colors.primary.slice(0, genderData.length),
                    borderWidth: 3,
                    borderColor: '#ffffff'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: {
                            padding: 20,
                            usePointStyle: true,
                            font: { size: 12 }
                        }
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                const percentage = ((context.parsed * 100) / total).toFixed(1);
                                return context.label + ': ' + context.parsed.toLocaleString() + ' (' + percentage + '%)';
                            }
                        }
                    }
                }
            }
        });
    }
    
    // Chart Kelompok Usia
    const ageData = <?php echo json_encode($demografiUsia, 15, 512) ?>;
    if (ageData.length > 0) {
        const ageCtx = document.getElementById('ageChart').getContext('2d');
        new Chart(ageCtx, {
            type: 'bar',
            data: {
                labels: ageData.map(item => item.label),
                datasets: [{
                    label: 'Jumlah Penduduk',
                    data: ageData.map(item => item.jumlah),
                    backgroundColor: colors.green,
                    borderColor: colors.greenDark,
                    borderWidth: 1,
                    borderRadius: 6
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: { display: false },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return 'Jumlah: ' + context.parsed.y.toLocaleString() + ' orang';
                            }
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return value.toLocaleString();
                            }
                        }
                    },
                    x: {
                        ticks: {
                            maxRotation: 45,
                            minRotation: 0
                        }
                    }
                }
            }
        });
    }
    
    // Chart Pendidikan
    const educationData = <?php echo json_encode($demografiPendidikan, 15, 512) ?>;
    if (educationData.length > 0) {
        const educationCtx = document.getElementById('educationChart').getContext('2d');
        new Chart(educationCtx, {
            type: 'bar',
            data: {
                labels: educationData.map(item => item.label),
                datasets: [{
                    label: 'Jumlah',
                    data: educationData.map(item => item.jumlah),
                    backgroundColor: colors.primary.slice(0, educationData.length),
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                indexAxis: 'y',
                plugins: {
                    legend: { display: false },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return 'Jumlah: ' + context.parsed.x.toLocaleString() + ' orang';
                            }
                        }
                    }
                },
                scales: {
                    x: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return value.toLocaleString();
                            }
                        }
                    }
                }
            }
        });
    }
    
    // Chart Pekerjaan
    const jobData = <?php echo json_encode($demografiPekerjaan, 15, 512) ?>;
    if (jobData.length > 0) {
        const jobCtx = document.getElementById('jobChart').getContext('2d');
        new Chart(jobCtx, {
            type: 'pie',
            data: {
                labels: jobData.map(item => item.label),
                datasets: [{
                    data: jobData.map(item => item.jumlah),
                    backgroundColor: colors.primary.slice(0, jobData.length),
                    borderWidth: 2,
                    borderColor: '#ffffff'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: {
                            padding: 15,
                            usePointStyle: true,
                            font: { size: 11 }
                        }
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                const percentage = ((context.parsed * 100) / total).toFixed(1);
                                return context.label + ': ' + context.parsed.toLocaleString() + ' (' + percentage + '%)';
                            }
                        }
                    }
                }
            }
        });
    }
    
    // Chart Agama (jika ada data)
    const religionData = <?php echo json_encode($demografiAgama ?? [], 15, 512) ?>;
    if (religionData.length > 0) {
        const religionCtx = document.getElementById('religionChart').getContext('2d');
        new Chart(religionCtx, {
            type: 'doughnut',
            data: {
                labels: religionData.map(item => item.label),
                datasets: [{
                    data: religionData.map(item => item.jumlah),
                    backgroundColor: colors.primary.slice(0, religionData.length),
                    borderWidth: 3,
                    borderColor: '#ffffff'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'bottom',
                        labels: {
                            padding: 20,
                            usePointStyle: true,
                            font: { size: 12 }
                        }
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                const percentage = ((context.parsed * 100) / total).toFixed(1);
                                return context.label + ': ' + context.parsed.toLocaleString() + ' (' + percentage + '%)';
                            }
                        }
                    }
                }
            }
        });
    }
    
    // Filter functionality
    const tahunSelect = document.getElementById('tahun');
    const dusunSelect = document.getElementById('dusun');
    
    if (tahunSelect) {
        // Populate tahun options from backend data
        const tahunList = <?php echo json_encode($tahunList ?? [], 15, 512) ?>;
        tahunSelect.innerHTML = '';
        tahunList.forEach(tahun => {
            const option = document.createElement('option');
            option.value = tahun;
            option.textContent = tahun;
            if (tahun == new Date().getFullYear()) {
                option.selected = true;
            }
            tahunSelect.appendChild(option);
        });
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\webdesa\resources\views/demografi.blade.php ENDPATH**/ ?>